//******************************************************************************
//
// MIDITrail / MTStaticCaption
//
// ÓILvV`NX
//
// Copyright (C) 2010-2022 WADA Masashi. All Rights Reserved.
//
//******************************************************************************

#include "StdAfx.h"
#include "YNBaseLib.h"
#include "MTStaticCaption.h"

using namespace YNBaseLib;


//******************************************************************************
// RXgN^
//******************************************************************************
MTStaticCaption::MTStaticCaption(void)
{
	m_pVertex = NULL;
	m_Color = D3DXCOLOR(1.0f, 1.0f, 1.0f, 1.0f);
}

//******************************************************************************
// fXgN^
//******************************************************************************
MTStaticCaption::~MTStaticCaption(void)
{
	Release();
}

//******************************************************************************
// ÓILvV
//******************************************************************************
int MTStaticCaption::Create(
		LPDIRECT3DDEVICE9 pD3DDevice,
		WCHAR* pFontName,
		unsigned long fontSize,
		WCHAR* pCaption
   )
{
	int result = 0;

	if (pD3DDevice == NULL) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}
	if ((pFontName == NULL) || (fontSize == 0) || (pCaption == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	Release();

	//eNX`
	result = _CreateTexture(pD3DDevice, pFontName, fontSize, pCaption);
	if (result != 0) goto EXIT;

	//_𐶐
	result = _CreateVertex();
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// eNX`TCY擾
//******************************************************************************
void MTStaticCaption::GetTextureSize(
		unsigned long* pHeight,
		unsigned long* pWidth
	)
{
	m_FontTexture.GetTextureSize(pHeight, pWidth);
}

//******************************************************************************
// ݒ
//******************************************************************************
void MTStaticCaption::SetColor(
		D3DXCOLOR color
	)
{
	m_Color = color;
}

//******************************************************************************
// `
//******************************************************************************
int MTStaticCaption::Draw(
		LPDIRECT3DDEVICE9 pD3DDevice,
		float x,
		float y,
		float magRate
	)
{
	int result = 0;
	HRESULT hresult = D3D_OK;
	D3DXMATRIX mtxWorld;

	if ((pD3DDevice == NULL) || (m_pVertex == NULL)) {
		result = YN_SET_ERR("Program error.", 0, 0);
		goto EXIT;
	}

	//_Wݒ
	_SetVertexPosition(
			m_pVertex,	//_Wz
			x,			//`ʒux
			y,			//`ʒuy
			magRate		//g嗦
		);

	//_Fݒ
	_SetVertexColor(m_pVertex, m_Color);

	//_OpCvCɃeNX`ݒ
	hresult = pD3DDevice->SetTexture(
					0,							//Xe[Wʎq
					m_FontTexture.GetTexture()	//eNX`IuWFNg
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//eNX`Xe[Wݒ
	//  J[ZF1gp  1F|S
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLOROP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_DIFFUSE);
	// At@ZF1gp  1FeNX`
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAOP,   D3DTOP_SELECTARG1);
	pD3DDevice->SetTextureStageState(0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE);

	//eNX`tB^
	pD3DDevice->SetSamplerState(0, D3DSAMP_MINFILTER, D3DTEXF_LINEAR);
	pD3DDevice->SetSamplerState(0, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR);

	//_OpCvCɒ_obt@FVFtH[}bgݒ
	hresult = pD3DDevice->SetFVF(_GetFVFFormat());
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

	//_OpCvCɃ}eAݒ
	//Ȃ

	//S{[h`
	hresult = pD3DDevice->DrawPrimitiveUP(
					D3DPT_TRIANGLESTRIP,			//v~eBu
					2,								//v~eBu
					m_pVertex,						//_f[^
					sizeof(MTSTATICCAPTION_VERTEX)	//_f[^̃TCY
				);
	if (FAILED(hresult)) {
		result = YN_SET_ERR("DirectX API error.", hresult, 0);
		goto EXIT;
	}

EXIT:;
	return result;
}

//******************************************************************************
// 
//******************************************************************************
void MTStaticCaption::Release()
{
	m_FontTexture.Clear();

	delete [] m_pVertex;
	m_pVertex = NULL;
}

//******************************************************************************
// eNX`
//******************************************************************************
int MTStaticCaption::_CreateTexture(
		LPDIRECT3DDEVICE9 pD3DDevice,
		const WCHAR* pFontName,
		unsigned long fontSize,
		const WCHAR* pCaption
	)
{
	int result = 0;
	bool isForceFixedPitch = false;
	unsigned long color = 0x00FFFFFF;

	//tHgݒFŒsb`
	result = m_FontTexture.SetFont(pFontName, fontSize, color, isForceFixedPitch);
	if (result != 0) goto EXIT;

	//^CꗗeNX`쐬
	result = m_FontTexture.CreateTexture(pD3DDevice, pCaption);
	if (result != 0) goto EXIT;

EXIT:;
	return result;
}

//******************************************************************************
// _
//******************************************************************************
int MTStaticCaption::_CreateVertex()
{
	int result = 0;
	unsigned long i = 0;
	MTSTATICCAPTION_VERTEX* pVertex = NULL;
	
	//_
	try {
		pVertex = new MTSTATICCAPTION_VERTEX[4];
	}
	catch (std::bad_alloc) {
		result = YN_SET_ERR("Could not allocate memory.", 0, 0);
		goto EXIT;
	}

	//_Wݒ
	_SetVertexPosition(
			pVertex,	//_Wz
			0.0f,		//`ʒux
			0.0f,		//`ʒuy
			1.0f		//g嗦
		);

	for (i = 0; i < 4; i++) {
		//e_̏Z
		pVertex[i].rhw = 1.0f;
		//e_̃fBt[YF
		pVertex[i].c = m_Color;
	}

	//eNX`W
	pVertex[0].t = D3DXVECTOR2(0.0f, 0.0f);
	pVertex[1].t = D3DXVECTOR2(1.0f, 0.0f);
	pVertex[2].t = D3DXVECTOR2(0.0f, 1.0f);
	pVertex[3].t = D3DXVECTOR2(1.0f, 1.0f);

	m_pVertex = pVertex;
	pVertex = NULL;

EXIT:;
	delete [] pVertex;
	return result;
}

//******************************************************************************
// _ʒuݒ
//******************************************************************************
void MTStaticCaption::_SetVertexPosition(
		MTSTATICCAPTION_VERTEX* pVertex,
		float x,
		float y,
		float magRate
	)
{
	unsigned long i = 0;
	unsigned long texHeight = 0;
	unsigned long texWidth = 0;
	float height = 0.0f;
	float width = 0.0f;

	//`TCY
	m_FontTexture.GetTextureSize(&texHeight, &texWidth);
	height = (float)texHeight * magRate;
	width  = (float)texWidth  * magRate;

	//_W
	pVertex[0].p = D3DXVECTOR3(0.0f , 0.0f,   0.0f);
	pVertex[1].p = D3DXVECTOR3(width, 0.0f,   0.0f);
	pVertex[2].p = D3DXVECTOR3(0.0f , height, 0.0f);
	pVertex[3].p = D3DXVECTOR3(width, height, 0.0f);

	//`ʒuɈړ
	for (i = 0; i < 4; i++) {
		pVertex[i].p.x += x;
		pVertex[i].p.y += y;
	}

	return;
}

//******************************************************************************
// _Fݒ
//******************************************************************************
void MTStaticCaption::_SetVertexColor(
		MTSTATICCAPTION_VERTEX* pVertex,
		D3DXCOLOR color
	)
{
	unsigned long i = 0;

	for (i = 0; i < 4; i++) {
		pVertex[i].c = color;
	}

	return;
}

