<?php

/**
 * mil - TeX ライクな文法による HTML 生成器
 */

$begin = microtime(true);

define('SITE_NAME', 'mil manual');

header('Content-type: text/html; charset=utf8');

require_once(dirname(__FILE__).'/mil//mil.php');

$page = @$_GET['p'];
if($page == null){
	$page = 'index';
}
$path = dirname(__FILE__).'/pages/'.$page.'.mil.txt';
if(!file_exists($path)){
	header('HTTP/1.0 404 Not Found');
	$page = 'errordocs/404';
	$path = dirname(__FILE__).'/pages/'.$page.'.mil.txt';
	$last_mod = false;
}else{
	$last_mod = date('Y/m/d H:i:s', filectime($path));
}
$source = file_get_contents($path);
$result = mil_convert($source, false);

?>
<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
	<head>
		<link rel="stylesheet" type="text/css" href="./mil/css.php" />
		<link rel="stylesheet" type="text/css" href="./csses/style.css" />
		<title><?php echo $result->getTitle(); ?> - <?php echo SITE_NAME; ?></title>
	</head>
	<body>
		<div class="header">
			<table style="width:100%;"><tr>
				<td class="sitename">
					<a href="./" title="mil - TeXライクなHTML生成機"><?php echo SITE_NAME; ?></a>
				</td>
				<td style="text-align:right;">
				 [ <a href="./pages/<?php echo $page; ?>.mil.txt" title="このページのソースコード">Source</a> ]
				</td>
			</tr></table>
		</div>
		<hr />
		<div class="body">
			<div class="menucontainer">
				<div class="mainmenu">
				<?php
				echo mil_convert(file_get_contents(dirname(__FILE__).'/pages/menu.mil.txt'), false)->result();
				?>
				</div>
				<p style="text-align:center;margin-top:3ex;margin-bottom:3ex;">
					<a href="http://sourceforge.jp/"><img src="http://sourceforge.jp/sflogo.php?group_id=4288&type=1" style="width:96px;height:31px;border:0px;" alt="SourceForge.JP" title="このプロジェクトは SourceForge.JP により支援されています"></a>
				</p>
			</div>
			<div class="maincontainer">
				<?php echo $result->result(); ?>
			</div>
		</div>
		<div class="footer">
			<hr />
			Convert time : <?php printf('%d', (microtime(true)-$begin)*1000); ?> ms.<br />
			Last modified : <?php echo ($last_mod===false)?'(unavailable)':$last_mod; ?><br />
			mil <?php echo MIL_VERSION; ?> - Copyright © <a href="http://mil.sourceforge.jp/?p=about/developer">mil developers team</a> 2009 all rights reserved.<br />
			Powered by <?php echo PHP_VERSION; ?>.
		</div>
	</body>
</html>

