<?php

/**
 * mil の設定ファイル。設定をここに叩く。
 */

define('MIL_VERSION', 'v0.1');

define('PACKAGE_DIR', dirname(__FILE__).'/packages');
define('EXCEPTION_DIR', dirname(__FILE__).'/exceptions');
define('UTILITY_DIR', dirname(__FILE__).'/util');

/**
 * コマンドおよび環境の呼び出し回数制限です。
 * あまり小さな値に設定すると、大規模なページを変換できないため、ある程度大きな値を設定します。
 */
define('MAX_CALL', 1024);

define('QUOTE_STYLE', ENT_COMPAT);
define('ENCODING', 'UTF-8');

/**
 * このディレクトリへの URL
 * 例えば、
 *   http://yourhost/somedirectory/mil/
 * に mil を導入したのならば、
 *   /somedirectory/mil/
 * を設定します。
 */
define('MIL_URL', './mil/');

/** パッケージの一覧 */
$packages = array(
	// 必須のパッケージです
	'system',
	// 一般的なコマンドが含まれています
	'general',
	// 数式を扱うためのパッケージです
	'math',
	// TeX
	'tex',
	'local'
);

?>
