<?php

require_once(dirname(__FILE__).'/MilUsage.php');

class MilUsageCommand extends MilUsage{
	
	private $arg;
	private $arg_list;
	
	/**
	 * $arg_list = array(
	 * 引数1 => 説明,
	 * 引数2 => 説明...
	 * );
	 */
	public function setArgument($arg, $arg_list){
		$this->arg = $arg;
		$this->arg_list = $arg_list;
	}
	
	public function toString(){
ob_start();
?>

<p class="usage"><?php echo $this->name; ?> コマンド</p>

<p class="usageDescription">説明</p>
\begin{quotation}
	<?php echo '\\\\'.$this->name.' '.$this->arg; ?>
\end{quotation}
<?php echo $this->description; ?>

<p class="usageArgument">引数</p>
<?php
if(count($this->arg_list) == 0){
	echo 'このコマンドには引数はありません';
}else{
	echo '\\begin{itemize}';
	foreach($this->arg_list as $name => $desc){
		echo '\\item '.$name.'<br />';
		echo '\\hspace{1em}'.$desc;
	}
	echo '\\end{itemize}';
}

$i = 0;
foreach($this->examples as $example){
	$i++;
	?>
	<p class="usageExample">例<?php echo $i; ?></p>
	\begin{quotation}
		<?php echo str_replace(array('\\', "\n"), array('\\\\', " \\br\n"), trim($example)); ?>
	\end{quotation}
	\begin{quotation}
		<?php echo $example; ?>
	\end{quotation}
	<?php
}
?>



<?php
return ob_get_clean();
	}
	
}

?>
