<?php

require_once(dirname(__FILE__).'/MilUsage.php');

class MilUsageEnvironment extends MilUsage{
	
	private $main_arg;
	private $arg;
	private $arg_list;
	
	public function setArgument($main_arg, $arg = '', $arg_list = array()){
		$this->main_arg = $main_arg;
		$this->arg = $arg;
		$this->arg_list = $arg_list;
	}
	
	public function toString(){
ob_start();
?>

<p class="usage"><?php echo $this->name; ?> 環境</p>

<p class="usageDescription">説明</p>
\begin{quotation}
	\\begin { <?php echo $this->name.' } '.$this->arg; ?> \br
		\hspace{1em} main_arg \br
	\\end { <?php echo $this->name; ?> }
\end{quotation}
<?php echo $this->description; ?>

<p class="usageArgument">引数</p>
<?php
echo '\\begin{itemize}';
echo '\\item main_arg <br />';
echo '\\hspace{1em}'.$this->main_arg;
if(count($this->arg_list) > 0){
	foreach($this->arg_list as $name => $desc){
		echo '\\item '.$name.'<br />';
		echo '\\hspace{1em}'.$desc;
	}
}
echo '\\end{itemize}';

$i = 0;
foreach($this->examples as $example){
	$i++;
	?>
	<p class="usageExample">例<?php echo $i; ?></p>
	\begin{quotation}
		<?php echo str_replace(array('\\', "\n"), array('\\\\', " \\br\n"), trim($example)); ?>
	\end{quotation}
	\begin{quotation}
		<?php echo $example; ?>
	\end{quotation}
	<?php
}
?>



<?php
return ob_get_clean();
	}
	
}

?>
