<?php

require_once(dirname(__FILE__).'/config.php');

require_once(dirname(__FILE__).'/core/MilParser.php');

require_once(dirname(__FILE__).'/exceptions/NoSuchPackageException.php');

// パッケージを読み込む
load_packages();

function mil_convert($source, $throws = true){
	if(!$throws)
		return mil_convert_handle_exception($source);
	$parser = new MilParser($source);
	$result = $parser->getResult();
	return $result;
}

function mil_convert_handle_exception($source){
	try{
		return mil_convert($source);
	}catch(NoSuchPackageException $e){
		return mil_make_error_message($e->getMessage());
	}catch(NoSuchPackageInitializerException $e){
		return mil_make_error_message($e->getMessage());
	}catch(MilException $e){
		return mil_make_error_message('予期せぬ例外が発生しました');
	}catch(Exception $e){
		return mil_make_error_message('予期せぬ例外が発生しました');
	}
}

function mil_get_css($package_name = null){
	global $packages;
	if($package_name == null){
		$result = '';
		foreach($packages as $package){
			$tmp = mil_get_css($package);
			if($tmp != false)
				$result .= $tmp;
		}
		return $result;
	}
	$css_func = 'package_'.$package_name.'_css';
	if(!function_exists($css_func)){
		return false;
	}
	$result = '';
	$result .= "/********************************************************************************\n";
	$result .= " * \n";
	$result .= ' * '.$package_name." パッケージの CSS\n";
	$result .= " * \n";
	$result .= " ********************************************************************************/\n";
	$result .= $css_func();
	$result .= "\n\n\n";
	return $result;
}

function mil_make_error_message($message){
	return "<div style=\"color:red\">$message</div>";
}

function load_packages(){
	global $packages;
	foreach($packages as $package_name){
		try{
			$load_path = PACKAGE_DIR.'/'.$package_name.'/load.php';
			if(!file_exists($load_path))
				throw new NoSuchPackageException("パッケージ、 $package_name の load.php が存在しません");
			require_once($load_path);
			$load_func = 'package_'.$package_name.'_load';
			if(!function_exists($load_func))
				throw new NoSuchPackageInitializerException("パッケージ、 $package_name の読み込み函数が存在しません");
			$load_func();
		}catch(MilException $e){
			echo $e->getMessage();
		}
	}
}

?>
