<?php

function environment_center_call($main_arg){
	return '<div style="text-align:center;">'.$main_arg.'</div>';
}

function environment_center_usage(){
	$u = new MilUsageEnvironment('center');
	$u->setDescription('中央寄せします。');
	$u->setArgument('中央寄せする対象。');
	return $u;
}

function environment_flushleft_call($main_arg){
	return '<div style="text-align:left;">'.$main_arg.'</div>';
}

function environment_flushleft_usage(){
	$u = new MilUsageEnvironment('flushleft');
	$u->setDescription('左寄せします。');
	$u->setArgument('左寄せする対象。');
	return $u;
}

function environment_flushright_call($main_arg){
	return '<div style="text-align:right;">'.$main_arg.'</div>';
}

function environment_flushright_usage(){
	$u = new MilUsageEnvironment('flushright');
	$u->setDescription('右寄せします。');
	$u->setArgument('右寄せする対象。');
	return $u;
}

function environment_blockcenter_call($arg_main, $args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$str = trim($arg_main);
	$width = trim($args[0]);
	return "<div style=\"text-align:center;width:$width;margin-left:auto;margin-right:auto;\">$str</div>";
}

function environment_blockcenter_usage(){
	$u = new MilUsageEnvironment('blockcenter');
	$u->setDescription('中央に width の幅を持ったブロック要素を出力します。');
	$u->setArgument('ブロック要素の内容。', '{ width }', array('width' => 'ブロック要素の幅を指定します。'));
	return $u;
}

function environment_blockleft_call($arg_main, $args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$str = trim($arg_main);
	$width = trim($args[0]);
	return "<div style=\"text-align:left;width:$width;margin-right:auto;\">$str</div>";
}

function environment_blockleft_usage(){
	$u = new MilUsageEnvironment('blockleft');
	$u->setDescription('左に width の幅を持ったブロック要素を出力します。');
	$u->setArgument('ブロック要素の内容。', '{ width }', array('width' => 'ブロック要素の幅を指定します。'));
	return $u;
}

function environment_blockright_call($arg_main, $args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$str = trim($arg_main);
	$width = trim($args[0]);
	return "<div style=\"text-align:right;width:$width;margin-left:auto;\">$str</div>";
}

function environment_blockright_usage(){
	$u = new MilUsageEnvironment('blockright');
	$u->setDescription('右に width の幅を持ったブロック要素を出力します。');
	$u->setArgument('ブロック要素の内容。', '{ width }', array('width' => 'ブロック要素の幅を指定します。'));
	return $u;
}

?>
