<?php

function command_colorbox_call($args, $parser){
	switch(count($args)){
		case 2:
			$color = trim($args[0]);
			$string = trim($args[1]);
			break;
		case 4:
			$r = $parser->parse_int($args[0]);
			$g = $parser->parse_int($args[1]);
			$b = $parser->parse_int($args[2]);
			$color = "rgb($r, $g, $b)";
			$string = trim($args[3]);
			break;
		default:
			throw new InvalidArgumentCountException();
	}
	return '<span style="background-color:'.$color.';">'.$string.'</span>';
}

// \border[option]{text}
function command_border_call($args, $parser){
	$num_args = count($args);
	if($num_args == 1){
		$style = make_border_style('');
		$text = trim($args[0]);
	}else if($num_args == 2){
		$style = make_border_style($args[0]);
		$text = trim($args[1]);
	}else{
		throw new InvalidArgumentCountException();
	}
	return "<span style=\"{$style}\">$text</span>";
}

// \begin{border}[[{width}] {style}]
function environment_border_call($main_arg, $args, $parser){
	$num_args = count($args);
	$width = '100%';
	$height = '100%';
	$style = make_border_style('');
	switch(count($args)){
		case 0:
			break;
		case 2:
			$style = make_border_style($args[1]);
		case 1:
			$width = trim($args[0]);
			break;
		default:
			throw new InvalidArgumentCountException();
	}
	return "<div style=\"{$style}width:$width;\">$main_arg</div>";
}

function make_border_style_call($options){
	$defaults = array(
		'width' => '1px',
		'style' => 'solid',
		'color' => 'black'
	);
	$left = $defaults;
	$right = $defaults;
	$top = $defaults;
	$bottom = $defaults;
	// parse option
	$options = explode(',', $options);
	foreach($options as $option){
		$tmp = explode('=', $option);
		if(count($tmp) != 2)
			continue;
		$key = trim($tmp[0]);
		$value = trim($tmp[1]);
		switch($key){
			// left
			case 'left-width':
				$left['width'] = $value;
				break;
			case 'left-style':
				$left['style'] = $value;
				break;
			case 'left-color':
				$left['color'] = $value;
				break;
			// right
			case 'right-width':
				$right['width'] = $value;
				break;
			case 'right-style':
				$right['style'] = $value;
				break;
			case 'right-color':
				$right['color'] = $value;
				break;
			// top
			case 'top-width':
				$top['width'] = $value;
				break;
			case 'top-style':
				$top['style'] = $value;
				break;
			case 'top-color':
				$top['color'] = $value;
				break;
			// bottom
			case 'bottom-width':
				$bottom['width'] = $value;
				break;
			case 'bottom-style':
				$bottom['style'] = $value;
				break;
			case 'bottom-color':
				$bottom['color'] = $value;
				break;
			// 一括
			case 'width':
				$left['width'] = $right['width'] = $top['width'] = $bottom['width'] = $value;
				break;
			case 'style':
				$left['style'] = $right['style'] = $top['style'] = $bottom['style'] = $value;
				break;
			case 'color':
				$left['color'] = $right['color'] = $top['color'] = $bottom['color'] = $value;
				break;
		}
	}
	
	$result = '';
	$result .= "border-left:{$left['width']} {$left['style']} {$left['color']};";
	$result .= "border-right:{$right['width']} {$right['style']} {$right['color']};";
	$result .= "border-top:{$top['width']} {$top['style']} {$top['color']};";
	$result .= "border-bottom:{$bottom['width']} {$bottom['style']} {$bottom['color']};";
	return $result;
}

function environment_quotation_call($arg_main, $args, $parser){
	$result = "<div class=\"quotation\">$arg_main</div>";
	return $result;
}

function environment_verbatim_call($arg_main, $args, $parser){
	$result = trim($arg_main);
	$result = str_replace('\\', '\\\\', $result);
	$result = preg_replace('/\\r?\\n/', "\\br\n", $result);
	return environment_quotation_call($result, $args, $parser);
}

?>
