<?php

/*
 *  - chapter
 *  - section
 *  - subsection
 *  - subsubsection
 * および、
 *  - tableofcontents
 * を提供します
 */

//define('CMD_CHAPTER_PRE', '第');
//define('CMD_CHAPTER_POST', '章');

/************************************************/
/* tableofcontents */

function command_tableofcontents_call($args, $parser){
	global $cmd_chapter_pre, $cmd_chapter_post;
	// 遅延型でなければ遅延型に
	if(!$parser->isDelay())
		return '@tableofcontents';
	$result = '';
	$result .= '<div class="tableofcontents_main">';
	
	$chapters = $parser->getVar('chapters');
	$sections = $parser->getVar('sections');
	$subsections = $parser->getVar('subsections');
	$subsubsections = $parser->getVar('subsubsections');
	// chapter
	for($chapter=1; $chapter<=count($chapters); $chapter++){
		$result .= '<div class="tableofcontents_chapter">\\ref{chapter'.$chapter.'}{'.$parser->getVar('chapter_pre').$chapter.$parser->getVar('chapter_post').'\\hspace{1em}'.$chapters[$chapter].'}';
		// section
		for($section=1; isset($sections[$chapter])&&$section<=count($sections[$chapter]); $section++){
			$result .= '<div class="tableofcontents_section">\\ref{section'.$chapter.'.'.$section.'}{'.$chapter.'.'.$section.'\\hspace{1em}'.$sections[$chapter][$section].'}';
			// subsection
			for($subsection=1; isset($subsections[$chapter][$section])&&$subsection<=count($subsections[$chapter][$section]); $subsection++){
				$result .= '<div class="tableofcontents_subsection">\\ref{subsection'.$chapter.'.'.$section.'.'.$subsection.'}{'.$chapter.'.'.$section.'.'.$subsection.'\\hspace{1em}'.$subsections[$chapter][$section][$subsection].'}';
				$result .= '</div>';
			}
			$result .= '</div>';
		}
		$result .= '</div>';
	}
	$result .= '</div>';
	$result = "\n\n$result\n\n";
	return $result;
}

function command_tableofcontents_usage(){
	$u = new MilUsageCommand('tableofcontents');
	$u->setDescription('\\\\chapter や \\\\section の内容の一覧を出力します。');
	return $u;
}

/************************************************/
/* title */

function command_set_Title_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$parser->setTitle($args[0]);
	return '';
}

function command_set_Title_usage(){
	$u = new MilUsageCommand('setTitle');
	$u->setDescription(htmlspecialchars('
		タイトルを指定します。
		このコマンドは何も出力しませんが、実装側で、
		\\begin{center}
			<title><?php echo $result->getTitle(); ?></title>
		\\end{center}
		などとしてページのタイトルを出力する際に役立ちます。
	'));
	$u->setArgument('{ title }', array('title' => 'ページのタイトル。'));
	return $u;
}

function command_title_call($args, $parser){
	$num_args = count($args);
	if($num_args < 1){
		throw new InvalidArgumentCountException();
	}
	$parser->setTitle($args[0]);
	$result = '<h1 class="title">'.$args[0].'</h1>';
	if($num_args > 1){
		$author = '???';
		$date = '????/??/?? ??:??:??';
		$tmp = explode(',', $args[1]);
		foreach($tmp as $tmp2){
			$tmp2 = explode('=', $tmp2);
			if(count($tmp2) != 2){
				$result .= '引数の形式が間違っています';
			}
			$tmp2[0] = trim($tmp2[0]);
			$tmp2[1] = trim($tmp2[1]);
			switch($tmp2[0]){
				case 'author':
					$author = $tmp2[1];
					break;
				case 'date':
					$date = $tmp2[1];
					break;
				default:
					$result .= $parser->errorOut('未知のオプション('.trim($tmp2[0]).')');
			}
		}
		$result .= '<p class="doc_info">Author : '.$author.'<br />'.$date.'</p>';
	}
	return $result;
}

function command_title_usage(){
	$u = new MilUsageCommand('title');
	$u->setDescription('ページのタイトルを出力します。執筆者や、執筆日時なども付加することができます。');
	$u->setArgument(
		'{ title } [ { info } ]', 
		array(
			'title' => 'ページのタイトル',
			'info' => htmlspecialchars('author=<<執筆者>>, date=<<執筆日時>> \br という形で指定します。')
		)
	);
	return $u;
}

/************************************************/
/* chapter, section, etc */

function command_chapter_call($args, $parser){
	$num_args = count($args);
	if($num_args != 1){
		throw new InvalidArgumentCountException();
	}
	$chapter = $parser->getVar('chapter') + 1;
	$result = '';
	$result .= $parser->getVar('chapter_pre').$chapter.$parser->getVar('chapter_post').'\\hspace{1em}'.$args[0];
	$parser->setVar('chapter', $chapter);
	$chapters = $parser->getVar('chapters');
	$chapters[$chapter] = $args[0];
	$parser->setVar('chapters', $chapters);
	$result = update_under_chapter($parser)."\n\n".'<h2 class="chapter">\\label{chapter'.$chapter.'}'.$result.'</h2>'."\n\n";
	return $result;
}

function command_chapter_usage(){
	$u = new MilUsageCommand('chapter');
	$u->setDescription('章立てをします。');
	$u->setArgument('{ name }', array('name' => '章の名前です。'));
	return $u;
}

function command_section_call($args, $parser){
	$num_args = count($args);
	if($num_args != 1){
		throw new InvalidArgumentCountException();
	}
	$chapter = $parser->getVar('chapter');
	$section = $parser->getVar('section') + 1;
	$result = '';
	$result .= $chapter.'.'.$section.' '.'\\hspace{1em}'.$args[0];
	$parser->setVar('section', $section);
	$sections = $parser->getVar('sections');
	$sections[$chapter][$section] = $args[0];
	$parser->setVar('sections', $sections);
	$result = update_under_section($parser)."\n\n".'<h3 class="section">\\label{section'.$chapter.'.'.$section.'}'.$result.'</h3>'."\n\n";
	return $result;
}

function command_section_usage(){
	$u = new MilUsageCommand('section');
	$u->setDescription('大見出しを立てます。');
	$u->setArgument('{ name }', array('name' => '大見出しの名前です。'));
	return $u;
}

function command_subsection_call($args, $parser){
	$num_args = count($args);
	if($num_args != 1){
		throw new InvalidArgumentCountException();
	}
	$chapter = $parser->getVar('chapter');
	$section = $parser->getVar('section');
	$subsection = $parser->getVar('subsection') + 1;
	$result = '';
	$result .= $chapter.'.'.$section.'.'.$subsection.'\\hspace{1em}'.$args[0];
	$parser->setVar('subsection', $subsection);
	$subsections = $parser->getVar('subsections');
	$subsections[$chapter][$section][$subsection] = $args[0];
	$parser->setVar('subsections', $subsections);
	$result = update_under_subsection($parser)."\n\n".'<h4 class="subsection">\\label{subsection'.$chapter.'.'.$section.'.'.$subsection.'}'.$result.'</h4>'."\n\n";
	return $result;
}

function command_subsection_usage(){
	$u = new MilUsageCommand('subsection');
	$u->setDescription('中見出しを立てます。');
	$u->setArgument('{ name }', array('name' => '中見出しの名前です。'));
	return $u;
}

function command_subsubsection_call($args, $parser){
	$num_args = count($args);
	if($num_args != 1){
		throw new InvalidArgumentCountException();
	}
	$chapter = $parser->getVar('chapter');
	$section = $parser->getVar('section');
	$subsection = $parser->getVar('subsection');
	$subsubsection = $parser->getVar('subsubsection') + 1;
	$result = '';
	$result .= $args[0];
	$parser->setVar('subsubsection', $subsubsection);
	$subsubsections = $parser->getVar('subsubsections');
	$subsubsections[$chapter][$section][$subsection][$subsubsection] = $args[0];
	$parser->setVar('subsubsections', $subsubsections);
	$result = update_under_subsubsection($parser)."\n\n".'<h5 class="subsubsection">\\label{subsubsection'.$chapter.'.'.$section.'.'.$subsection.'.'.$subsubsection.'}'.$result.'</h5>'."\n\n";
	return $result;
}

function command_subsubsection_usage(){
	$u = new MilUsageCommand('subsubsection');
	$u->setDescription('小見出しを立てます。');
	$u->setArgument('{ name }', array('name' => '小見出しの名前です。'));
	return $u;
}

/************************************************/
/* updater */

function update_under_chapter($parser){
	$parser->setVar('section', 0);
	return update_under_section($parser);
}

function update_under_section($parser){
	$parser->setVar('subsection', 0);
	$parser->setVar('equation', 0);
	return update_under_subsection($parser).'\\theendnotes ';
}

function update_under_subsection($parser){
	$parser->setVar('subsubsection', 0);
	return update_under_subsubsection($parser);
}

function update_under_subsubsection($parser){
	// Nothing to do
	return '';
}

?>
