<?php

function command_fontsize_call($args, $parser){
	if(count($args) != 2){
		throw new InvalidArgumentCountException();
	}
	return '<span style="font-size:'.trim($args[0]).';">'.trim($args[1]).'</span>';
}

function command_fontsize_usage(){
	$u = new MilUsageCommand('fontsize');
	$u->setDescription('文字サイズを変更します。');
	$u->setArgument(
		'{ size } { text }',
		array(
			'size' => '文字サイズを指定します。単位は px や \\% などで指定します。',
			'text' => '文字サイズを変更する対象の文字列です。'
		)
	);
	$u->addExample('\\fontsize{20px}{20 ピクセルの文字}');
	return $u;
}

function command_tiny_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="tiny">'.trim($args[0]).'</span>';
}

function command_scriptsize_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="scriptsize">'.trim($args[0]).'</span>';
}

function command_footnotesize_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="footnotesize">'.trim($args[0]).'</span>';
}

function command_small_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="small">'.trim($args[0]).'</span>';
}

function command_normalsize_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="normalsize">'.trim($args[0]).'</span>';
}

function command_large_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="large">'.trim($args[0]).'</span>';
}

function command__Large_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="Large">'.trim($args[0]).'</span>';
}

function command__L_A_R_G_E_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="LARGE">'.trim($args[0]).'</span>';
}

function command_huge_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="huge">'.trim($args[0]).'</span>';
}

function command__Huge_call($args, $parser){
	if(count($args) < 1)
		throw new InvalidArgumentCountException();
	return '<span class="Huge">'.trim($args[0]).'</span>';
}

?>
