<?php

function command_footnote_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$new_note = $args[0];
	$chapter = $parser->getVar('chapter');
	$section = $parser->getVar('section');
	$footnote = $parser->getVar('footnote') + 1;
	$footnote_name = $chapter.'.'.$section.'.'.$footnote;
	$footnotes = $parser->getVar('footnotes');
	$footnotes[$footnote] = array(
		'note' => $new_note,
		'name' => $footnote_name
	);
	$result = '\label{FOOTNOTE'.$footnote_name.'}{ '.$footnote.' }<span class="footnote"> [@ref{footnote'.$footnote_name.'}] </span>';
	$parser->setVar('footnote', $footnote);
	$parser->setVar('footnotes', $footnotes);
	return $result;
}

function command_footnote_usage(){
	$u = new MilUsageCommand('footnote');
	$u->setDescription('注釈を出力します。');
	$u->setArgument('{ text }', array('text' => '注釈の内容'));
	$u->addExample('注釈をここに\\footnote{これは注釈です。}出力します。注釈の内容がこれより下部のどこかに出力されているはずです。');
	return $u;
}

function command_theendnotes_call($args, $parser){
	$footnote = $parser->getVar('footnote');
	$footnotes = $parser->getVar('footnotes');
	if($footnote < 1){
		return '';
	}
	$result = '';
	for($i=1; $i<=$footnote; $i++){
		$note = $footnotes[$i]['note'];
		$footnote_name = $footnotes[$i]['name'];
		$result .= '<p class="theendnote">\hspace{0.5em}\label{footnote'.$footnote_name.'}{ '.$i.' }<span class="footnote">[@ref{FOOTNOTE'.$footnote_name.'}]</span>';
		$result .= '<span class="note">'.$note.'</span></p>';
	}
	$parser->setVar('footnote', 0);
	$parser->setVar('footnotes', array());
	$result = "<div class=\"theendnotes\"><hr class=\"theendnote_hr\" />$result</div>";
	return $result;
}

function command_theendnotes_usage(){
	$u = new MilUsageCommand('theendnotes');
	$u->setDescription('このコマンドが入力された位置に、登録した注釈を表示します。このコマンドは、ページの最後や、各 \\\\chapter コマンドの前に自動的に挿入されます。');
	return $u;
}

?>
