<?php

function command_html_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	return trim(html_entity_decode($args[0]));
}

function command_html_usage(){
	$u = new MilUsageCommand('html');
	$u->setDescription('引数の内容をそのまま HTML として出力します。大量の文字列を HTML として出力したい場合には、 HTML 環境を使用することが推奨されます。また例については html 環境のマニュアルを参照してください。');
	$u->setArgument('{ html }', array('html' => 'HTML として出力したい文字列。'));
	return $u;
}

function environment_html_call($arg_main, $args, $parser){
	return trim(html_entity_decode($arg_main));
}

function environment_html_usage(){
	$u = new MilUsageEnvironment('html');
	$u->setDescription('引数の内容をそのまま HTML として出力します。少量の HTML を出力するだけならば、\\\\html コマンドを用いた方が簡単です。');
	$u->setArgument('HTML として出力したい文字列。');
	$u->addExample('
		\\begin{html}
			ページを表示してから<span id="timeElapsed">?</span>秒経過
			<script type="text/javascript">
				var timeElapsed = 0;
				updateTimer();
				function updateTimer(){
					document.getElementById("timeElapsed").innerHTML = timeElapsed;
					timeElapsed++;
					setTimeout("updateTimer()", 1000);
				}
			</script>
		\\end{html}
	');
	return $u;
}

?>
