<?php

// \label{label_identifier}[label_name]
// ex) \label{eqnLorentz}{ローレンツ変換}
function command_label_call($args, $parser){
	$num_args = count($args);
	if($num_args < 1){
		throw new InvalidArgumentCountException();
	}
	$label_id = $args[0];
	$label_name = ($num_args==1)?$label_id:$args[1];
	$labels = $parser->getVar('labels');
	$labels[$label_id] = $label_name;
	$parser->setVar('labels', $labels);
	return '<a id="'.$label_id.'"></a>';
}

function command_label_usage(){
	$u = new MilUsageCommand('label');
	$u->setDescription('ラベルを設定します。何も表示されませんが、後で \\\\ref コマンドにより、ラベルの設定箇所へのページ内リンクを張ることができます。\\\\ref コマンドも参照してください。');
	$u->setArgument(
		'{ label_identifier } [ label_name ]',
		array(
			'label_identifier' => 'ラベルを区別するための文字列を指定します。英数字を使って、自分の分かりやすい名前を設定します。',
			'label_name' => '\\\\ref コマンドにより呼び出されたときに表示する名前です。'
		)
	);
	$u->addExample('
		\\label{labelEx1}ここにラベルを設定。
		ラベル \\ref{labelEx1} に飛びます。
		ラベル \\ref{labelEx1}{ラベルの例 #1} に飛びます。
	');
	$u->addExample('
		\\label{labelEx2}{ラベルの例 #2}ここにラベルを設定。
		ラベル \\ref{labelEx2} に飛びます。
		\\\\ref コマンドの第二引数を指定することで、 \\ref{labelEx2}{ラベルの例 (2)} と名前を変えることができます。
	');
	return $u;
}

// \ref{label_identifier}[string = label_name]
function command_ref_call($args, $parser){
	$num_args = count($args);
	if($num_args < 1){
		throw new InvalidArgumentCountException();
	}
	// 遅延型へ
	if(!$parser->isDelay()){
		switch(count($args)){
			case 1:
				return '@ref{'.$args[0].'}';
			case 2:
				return '@ref{'.$args[0].'}{'.$args[1].'}';
			default:
				throw new InvalidArgumentCountException();
		}
	}
	
	$labels = $parser->getVar('labels');
	$label_id = $args[0];
	if(!isset($labels[$label_id])){
		return $parser->errorOut('指定されたラベルが見つかりませんでした:'.$label_id);
	}
	$string = (count($args)==1)?$labels[$label_id]:$args[1];
	return '<a href="#'.$label_id.'">'.$string.'</a>';
}

function command_ref_usage(){
	$u = new MilUsageCommand('ref');
	$u->setDescription('指定したラベルへのページ内リンクを生成します。使用例は、\\\\label コマンドのマニュアルを参照してください。');
	$u->setArgument(
		'{ label_identifier } [ { label_name } ]',
		array(
			'label_identifier' => 'ラベル名を指定します。',
			'label_name' => 'ラベルの設定した表示名を置き換えるときにこの引数を指定します。'
		)
	);
	return $u;
}

?>
