<?php

function command_unicode_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	$num_str = trim($args[0]);
	if($num_str[0] == 'x'){
		$num = (int)(base_convert(substr($num_str, 1), 16, 10));
	}else{
		$num = (int)$num_str;
	}
	return '&#'.$num.';';
}

function command_unicode_usage(){
	$u = new MilUsageCommand('unicode');
	$u->setDescription('引数で指定されたコード番号に対応するユニコード文字を出力します。');
	$u->setArgument('code', array('code' => 'コード番号。10進数もしくは16進数で指定できます。16進数を用いる場合には、先頭に「x」を付加してください。'));
	$u->addExample('	張\\unicode{37059}');
	$u->addExample('	張\\unicode{x90c3}');
	return $u;
}

function command__A_E_call(){
	return '&AElig;';
}

function command__A_E_usage(){
	$u = new MilUsageCommand('AE');
	$u->setDescription('「\\AE」と表示します。');
	return $u;
}

function command_copyright_call(){
	return '&copy;';
}

function command_copyright_usage(){
	$u = new MilUsageCommand('copyright');
	$u->setDescription('「\\copyright」と表示します。');
	return $u;
}

function command_texttrademark_call(){
	return '&trade;';
}

function command_texttrademark_usage(){
	$u = new MilUsageCommand('texttrademark');
	$u->setDescription('「\\texttrademark」と表示します。');
	return $u;
}

function command_textregistered_call(){
	return '&reg;';
}

function command_textregistered_usage(){
	$u = new MilUsageCommand('textregistered');
	$u->setDescription('「\\textregistered」と表示します。');
	return $u;
}

/* エス語。他意はない
 * Ĉ: &#264;
 * ĉ: &#265;
 * Ĝ: &#284;
 * ĝ: &#285;
 * Ĥ: &#292;
 * ĥ: &#293;
 * Ĵ: &#308;
 * ĵ: &#309;
 * Ŝ: &#348;
 * ŝ: &#349;
 * Ŭ: &#364;
 * ŭ: &#365;
 */
function command__C___call(){ return '\\unicode{264}'; }
function command__C___usage(){
	$u = new MilUsageCommand('C_');
	$u->setDescription('「\\C_」と表示します。');
	return $u;
}
function command_c___call (){ return '\\unicode{265}'; }
function command_c___usage(){
	$u = new MilUsageCommand('c_');
	$u->setDescription('「\\c_」と表示します。');
	return $u;
}
function command__G___call(){ return '\\unicode{284}'; }
function command__G___usage(){
	$u = new MilUsageCommand('G_');
	$u->setDescription('「\\G_」と表示します。');
	return $u;
}
function command_g___call (){ return '\\unicode{285}'; }
function command_g___usage(){
	$u = new MilUsageCommand('g_');
	$u->setDescription('「\\g_」と表示します。');
	return $u;
}
function command__H___call(){ return '\\unicode{292}'; }
function command__H___usage(){
	$u = new MilUsageCommand('H_');
	$u->setDescription('「\\H_」と表示します。');
	return $u;
}
function command_h___call (){ return '\\unicode{293}'; }
function command_h___usage(){
	$u = new MilUsageCommand('h_');
	$u->setDescription('「\\h_」と表示します。');
	return $u;
}
function command__J___call(){ return '\\unicode{308}'; }
function command__J___usage(){
	$u = new MilUsageCommand('J_');
	$u->setDescription('「\\J_」と表示します。');
	return $u;
}
function command_j___call (){ return '\\unicode{309}'; }
function command_j___usage(){
	$u = new MilUsageCommand('j_');
	$u->setDescription('「\\j_」と表示します。');
	return $u;
}
function command__S___call(){ return '\\unicode{348}'; }
function command__S___usage(){
	$u = new MilUsageCommand('S_');
	$u->setDescription('「\\S_」と表示します。');
	return $u;
}
function command_s___call (){ return '\\unicode{349}'; }
function command_s___usage(){
	$u = new MilUsageCommand('s_');
	$u->setDescription('「\\s_」と表示します。');
	return $u;
}
function command__U___call(){ return '\\unicode{364}'; }
function command__U___usage(){
	$u = new MilUsageCommand('U_');
	$u->setDescription('「\\U_」と表示します。');
	return $u;
}
function command_u___call (){ return '\\unicode{365}'; }
function command_u___usage(){
	$u = new MilUsageCommand('u_');
	$u->setDescription('「\\u_」と表示します。');
	return $u;
}

?>
