<?php

function command_textbf_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	return "<span class=\"textbf\">{$args[0]}</span>";
}

function command_textbf_usage(){
	$u = new MilUsageCommand('textbf');
	$u->setDescription('引数部分を太字にします。');
	$u->setArgument('text', array('text' => '太字にしたい文字列'));
	$u->addExample('\\textbf{太字}');
	return $u;
}

function command_textit_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	return "<span class=\"textit\">{$args[0]}</span>";
}

function command_textit_usage(){
	$u = new MilUsageCommand('textit');
	$u->setDescription('引数部分を斜体にします。');
	$u->setArgument('text', array('text' => '斜体にしたい文字列'));
	$u->addExample('\\textit{斜体}');
	return $u;
}

function command_color_call($args, $parser){
	switch(count($args)){
		case 2:
			$color = trim($args[0]);
			$string = trim($args[1]);
			break;
		case 4:
			$r = (int)($args[0]);
			$g = (int)($args[1]);
			$b = (int)($args[2]);
			$color = "rgb($r, $g, $b)";
			$string = trim($args[3]);
			break;
		default:
			throw new InvalidArgumentCountException();
	}
	$result = '<span style="color:'.$color.';">'.$string.'</span>';
	return $result;
}

function command_color_usage(){
	$u = new MilUsageCommand('color');
	$u->setDescription('文字色を変更します。');
	$u->setArgument(
		'{ color } { text } | { r } { g } { b } { text }', 
		array(
			'color' => '色を指定します。色名で指定するか、#RRGGBB 形式で指定します。',
			'r' => 'r 値です。10進数で指定します。',
			'g' => 'g 値です。10進数で指定します。',
			'b' => 'b 値です。10進数で指定します。',
			'text' => '色を変更したい文字列です。'
		)
	);
	$u->addExample('\\color{red}{赤}');
	$u->addExample('\\color{0}{0}{255}{青}');
	return $u;
}

function command_underline_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	return "<span class=\"underline\">{$args[0]}</span>";
}

function command_underline_usage(){
	$u = new MilUsageCommand('underline');
	$u->setDescription('対象の文字列に下線を引きます。');
	$u->setArgument('{ text }', array('text' => '下線を引きたい文字列。'));
	$u->addExample('\\underline{下線}');
	return $u;
}

function command_sout_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	return '<del>'.trim($args[0]).'</del>';
}

function command_sout_usage(){
	$u = new MilUsageCommand('sout');
	$u->setDescription('対象の文字列に取り消し線を引きます。');
	$u->setArgument('{ text }', array('text' => '取り消し線を引きたい文字列。'));
	$u->addExample('\\underline{取り消し線}');
	return $u;
}

function command_ruby_call($args, $parser){
	if(count($args) < 2){
		throw new InvalidArgumentCountException();
	}
	$rb = $args[0];
	$rt = $args[1];
	$result = "<ruby><rb>$rb</rb><rp>(</rp><rt>$rt</rt><rp>)</rp></ruby>";
	return $result;
}

function command_ruby_usage(){
	$u = new MilUsageCommand('ruby');
	$u->setDescription('ルビを降るコマンドです。ブラウザで対応していない場合には、「()」のなかにルビが出力されます。');
	$u->setArgument(
		'{ text } { ruby }', 
		array(
			'text' => 'ルビをふる対象。',
			'ruby' => 'ルビ。'
		)
	);
	$u->addExample('\\ruby{漢字}{かんじ}');
	return $u;
}

?>
