<?php

// \url{href}[{text}[{title}]]
function command_url_call($args, $parser){
	switch(count($args)){
		case 1:
			$title = $text = $href = trim($args[0]);
			break;
		case 2:
			$href = trim($args[0]);
			$title = $text = trim($args[1]);
			break;
		case 3:
			$href = trim($args[0]);
			$text = trim($args[1]);
			$title = trim($args[2]);
			break;
		default:
			throw new InvalidArgumentCountException();
	}
	return '<a href="'.$href.'" title="'.$title.'">'.$text.'</a>';
}

function command_url_usage(){
	$u = new MilUsageCommand('url');
	$u->setDescription('リンクを出力します。');
	$u->setArgument(
		'{ url } [ { text } [ { tooltip } ] ]',
		array(
			'url' => 'リンク先アドレスです。',
			'text' => 'リンクとして表示する文字列です。未指定の場合、url と同内容を出力します。',
			'tooltip' => 'リンクの上にマウスカーソルを重ねたときに表示されるツールチップです。未指定の場合 text と同内容が出力されます。'
		)
	);
	$u->addExample('\\url{http://example.com/}{example.com}');
	$u->addExample('\\url{mailto://usr\\@example.com}{usr\\@example.com}');
	return $u;
}

function command_href_call($args, $parser){
	return command_url_call($args, $parser);
}

function command_href_usage(){
	$u = new MilUsageCommand('href');
	$u->setDescription('リンクを出力します。これは url のエイリアスです。使用例などは url コマンドのマニュアルを参照してください。');
	$u->setArgument(
		'{ url } [ { text } [ { tooltip } ] ]',
		array(
			'url' => 'リンク先アドレスです。',
			'text' => 'リンクとして表示する文字列です。未指定の場合、url と同内容を出力します。',
			'tooltip' => 'リンクの上にマウスカーソルを重ねたときに表示されるツールチップです。未指定の場合 text と同内容が出力されます。'
		)
	);
	return $u;
}

?>
