<?php

function package_local_load(){

}

function package_local_initialize(){

}

function package_local_css(){
ob_start();
?>
.menu{
}
.menutitle{
	text-decoration : underline;
}
.submenu{
	margin-left : 1em;
}
.menuitem{
}
<?php
return ob_get_clean();
}

// \begin{menu}{title}
//  content
// \end{menu}
function environment_menu_call($main_arg, $args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	$result = '';
	$result .= '<div class="menu">';
	$result .= '<span class="menutitle">+ '.$args[0].'</span>';
	$result .= '<div class="submenu">'.trim($main_arg).'</div>';
	$result .= '</div>';
	return $result;
}

function environment_menu_usage(){
	$u = new MilUsageEnvironment('menu');
	$u->setDescription('メニューを表示します。');
	$u->setArgument('サブメニュー。', '{ title }', array('title' => 'メニュー項目名'));
	$u->addExample('
		\\begin{menu}{宇宙史}
			\\menuitem{cosmhist/inflation}{インフレーション}{宇宙は量子論的揺らぎから誕生した}
			\\menuitem{cosmhist/bigbang}{ビックバン}{宇宙初期に大爆発が起こった}
			\\menuitem{cosmhist/trans}{晴れ上がり}{光子が遮られることなく進める時代に}
		\\end{menu}
	');
	return $u;
}

// 内部リンク
function command_menuitem_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	return '<p class="menuitem">&gt; '.command_ilink_call($args, $parser).'</p>';
}

function command_menuitem_usage(){
	$u = new MilUsageCommand('menuitem');
	$u->setDescription('メニュー項目です。 menu 環境の中に含めます。例は menu 環境のマニュアルを参照してください。');
	$u->setArgument(
		'{ page } [ { text } [ { tooltip } ] ]',
		array(
			'page' => '内部リンク。 (\\\\ilink コマンドを参照してください)',
			'text' => 'メニュー名。',
			'tooltip' => 'ツールチップ。'
		)
	);
	return $u;
}

// 外部リンク
function command_menuitem_Ex_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	return '<p class="menuitem">&gt; '.command_url_call($args, $parser).'</p>';
}

function command_menuitem_Ex_usage(){
	$u = new MilUsageCommand('menuitemEx');
	$u->setDescription('メニュー項目です。 menu 環境の中に含めます。\\\\menuitem コマンドとほぼ同じですが、こちらは外部リンクです。');
	$u->setArgument(
		'{ page } [ { text } [ { tooltip } ] ]',
		array(
			'page' => '内部リンク。 (\\\\ilink コマンドを参照してください)',
			'text' => 'メニュー名。',
			'tooltip' => 'ツールチップ。'
		)
	);
	return $u;
}

// internal link
// \ilink{page}[{text}[{title}]]
function command_ilink_call($args, $parser){
	switch(count($args)){
		case 1:
			$title = $text = trim($args[0]);
			$page = './?p='.trim($args[0]);
			break;
		case 2:
			$page = './?p='.trim($args[0]);
			$title = $text = trim($args[1]);
			break;
		case 3:
			$page = './?p='.trim($args[0]);
			$text = trim($args[1]);
			$title = trim($args[2]);
			break;
		default:
			throw new InvalidArgumentCountException();
	}
	$result = '\\url{'.$page.'}{'.$text.'}{'.$title.'}';
	return $result;
}

function command_ilink_usage(){
	$u = new MilUsageCommand('ilink');
	$u->setDescription('内部リンクを作成します。');
	$u->setArgument(
		'{ page } [ { text } [ { tooltip } ] ]',
		array(
			'page' => '内部リンク。 pages/<page>.mil.txt の内容のページへ飛びます。',
			'text' => 'リンクへの文字列。 指定しなかった場合には、 page と同内容が出力されます。',
			'tooltip' => 'ツールチップ。 指定しなかった場合には text と同内容が出力されます。'
		)
	);
	$u->addExample('\\ilink{index}{トップページへ}{最初のページ}');
	return $u;
}

?>
