<?php

define('MATH2PNG', MIL_URL.'util/tex/math2png.php');

function package_math_load(){

}

function package_math_initialize($parser){

}

function environment_equation_call($main_arg, $args, $parser){
	if(count($args) > 1){
		throw new InvalidArgumentCountException();
	}
	$exp = preg_replace('/\\s*\\r?\\n\\s*/s', ' ', $main_arg);
	$exp = trim($exp);
	$eqn = equation($exp, 'displaystyle', $parser);
	$label = @$args[0];
	return equation_output($eqn, $label, $parser);
}

function environment_equation_usage(){
	$u = new MilUsageEnvironment('equation');
	$u->setDescription('前後に改行を挟み、行の中央に数式を表示します。');
	$u->setArgument('表示したい数式。', '[ { label } ]', array('label' => '後で数式番号を参照するためのラベルを指定します。'));
	$u->addExample('
		\\begin{equation}
			E = m \gamma c^2
		\\end{equation}
	');
	$u->addExample('
		\\begin{equation}{gamma}
			\\gamma := \\frac{1}{\\sqrt{1-\beta^2}}
		\\end{equation}
		\\equation{\\gamma} は、(\\ref{gamma})式で与えられる。
	');
	return $u;
}

function command_equation_call($args, $parser){
	if(count($args) != 1){
		throw new InvalidArgumentCountException();
	}
	$exp = $args[0];
	return equation($exp, 'textstyle', $parser);
}

function command_equation_usage(){
	$u = new MilUsageCommand('equation');
	$u->setDescription('インライン数式を表示します。これは、\\$exp\\$ と同等です。');
	$u->setArgument('exp', array('exp' => '表示したい数式。'));
	$u->addExample('函数 \\equation{f(x)} の微分可能性は…');
	return $u;
}

function equation($exp, $style, $parser){
	$q = html_entity_decode($exp);
	$exp = str_replace(array('\\',"\r\n"), array('\\\\',' '), $q);
	return '<img src="'.MATH2PNG.'?q='.urlencode($q).'&t='.$style.'" alt="'.htmlspecialchars($exp).'" title="'.htmlspecialchars($exp).'" />';
}

function equation_output($image_tag, $label, $parser){
	$equation = $parser->getVar('equation') + 1;
	$equation_name = $parser->getVar('chapter').'.'.$parser->getVar('section').'.'.$equation;
	$result = '
		<table style="width:100%;"><tr>
			<td style="text-align:center;">'.$image_tag.'</td>
			<td style="text-align:center;width:5em;">('.$equation_name.')\\label{'.$label.'}{'.$equation_name.'}</td>
		</tr></table>
	';
	$parser->setVar('equation', $equation);
	return $result;
}

?>
