<?php

/**
 * system パッケージ
 */

function package_system_load(){

}

function package_system_initialize($parser){
	
}

function package_system_css(){
return <<<EOM
.environment{
	margin: 0.5ex 0.5em;
}
div.paragraph{
	margin: 1ex 0.5em;
/*	padding: 0.5ex 0.5em;*/
}
p{
	margin: 0px 0px;
}
.error{
	color: red;
}
.usage{
	font-size: 100%;
	font-weight: bold;
	padding-left: 0.5em;
	margin-top: 3ex;
	margin-bottom: 1ex;
	background-color: #f6f6f6;
	border-bottom: 1px solid #999999;
	border-left: 3px solid #999999;
}
.usageDescription, .usageArgument, .usageExample{
	font-size: 100%;
	font-weight: bold;
	padding-left: 1.5em;
	margin-top: 1ex;
	margin-bottom: 1ex;
	border-bottom:1px solid #999999;
}
EOM;
}

function command_dummy_call(){
	return '::verb::';
}

function command_dummy_usage(){
	$u = new MilUsageCommand('dummy');
	$u->setDescription('どんな引数を与えても何も返さないコマンドです。');
	return $u;
}

function environment_dummy_call(){
	return '::verb::';
}

function environment_dummy_usage(){
	$u = new MilUsageEnvironment('dummy');
	$u->setDescription('どんな引数を与えても、何も返さない環境です。');
	return $u;
}

function command_error_call($args){
	return '<p class="error">'.$args[0].'</p>';
}

function command_error_usage(){
	$u = new MilUsageCommand('error');
	$u->setDescription('エラーメッセージを出力するためのコマンドです。');
	$u->setArgument('{ msg }', array('msg' => 'エラーメッセージ'));
	$u->addExample('\\error{エラーが発生しました}');
	return $u;
}

function command_command_List_call($args, $parser){
	$funcs = get_defined_functions();
	$usrfuncs = $funcs['user'];
	$commands = array();
	// 有効な函数のみ抽出する
	foreach($usrfuncs as $func){
		$status = preg_match('/command_([_a-zA-Z0-9]+)_call/', $func, $matches);
		if($status == 0)
			continue;
		$cmd = $parser->fromRealFunctionName($matches[1]);
		$commands[] = $cmd;
	}
	usort($commands, create_function('$a, $b', 'return strcasecmp($a, $b);'));
	$result = '';
	// 一覧を生成
	$result .= '\\begin{tabular}{llll}';
	$i = 0;
	foreach($commands as $cmd){
		$result .= '\\ref{commandUsage'.$cmd.'}{'.$cmd.'} '.($i==3?"\\\\ \n":'& ');
		$i = ($i+1)%4;
	}
	$result .= '\\end{tabular}';
	// 本体
	foreach($commands as $cmd){
		$usage = $parser->commandUsage($cmd);
		$result .= '\\label{commandUsage'.$cmd.'}';
		if($usage == false){
			$result .= '<p class="usage">'.$cmd.' コマンド</p>';
			$result .= '\\error{\\hspace{2em}このコマンドのマニュアルはありません}';
		}else{
			$result .= $usage->toString();
		}
	}
	return $result;
}

function command_command_List_usage(){
	$u = new MilUsageCommand('commandList');
	$u->setDescription('全コマンドのマニュアルを出力します。');
	return $u;
}

function command_environment_List_call($args, $parser){
	$funcs = get_defined_functions();
	$usrfuncs = $funcs['user'];
	$environments = array();
	// 有効な函数のみ抽出する
	foreach($usrfuncs as $func){
		$status = preg_match('/environment_([_a-zA-Z0-9]+)_call/', $func, $matches);
		if($status == 0)
			continue;
		$cmd = $parser->fromRealFunctionName($matches[1]);
		$environments[] = $cmd;
	}
	usort($environments, create_function('$a, $b', 'return strcasecmp($a, $b);'));
	$result = '';
	// 一覧を生成
	$result .= '\\begin{tabular}{llll}';
	$i = 0;
	foreach($environments as $env){
		$result .= '\\ref{environmentUsage'.$env.'}{'.$env.'} '.($i==3?"\\\\ \n":'& ');
		$i = ($i+1)%4;
	}
	$result .= '\\end{tabular}';
	// 本体
	foreach($environments as $env){
		$usage = $parser->environmentUsage($env);
		$result .= '\\label{environmentUsage'.$env.'}';
		if($usage == false){
			$result .= '<p class="usage">'.$env.' 環境</p>';
			$result .= '\\error{\\hspace{2em}この環境のマニュアルはありません}';
		}else{
			$result .= $usage->toString();
		}
	}
	return $result;
}

function command_environment_List_usage(){
	$u = new MilUsageCommand('environmentList');
	$u->setDescription('全環境のマニュアルを出力します。');
	return $u;
}

function command_command_Usage_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	$usage = $parser->commandUsage($args[0]);
	if($usage === false){
		return $parser->errorOut($args[0].' コマンドのマニュアルが見つかりません');
	}
	return $usage->toString();
}

function command_command_Usage_usage(){
	$u = new MilUsageCommand('commandUsage');
	$u->setDescription('指定したコマンドのマニュアルを表示します。');
	$u->setArgument('{ cmd }', array('cmd' => 'マニュアルを出力したいコマンド名'));
	return $u;
}

function command_environment_Usage_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	$usage = $parser->environmentUsage($args[0]);
	if($usage === false){
		return $parser->errorOut($args[0].' 環境のマニュアルが見つかりません');
	}
	return $usage->toString();
}

function command_environment_Usage_usage(){
	$u = new MilUsageCommand('environmentUsage');
	$u->setDescription('指定した環境のマニュアルを表示します。');
	$u->setArgument('{ env }', array('env' => 'マニュアルを出力したい環境名'));
	return $u;
}

?>
