<?php

define('TEX2PNG', MIL_URL.'util/tex/tex2png.php');

function package_tex_load(){

}

function package_tex_initialize(){

}

function command__Te_X_call(){
	return '<img src="'.MIL_URL.'images/TeX.png" alt="TeX" title="TeX" />';
}

function command__Te_X_usage(){
	$u = new MilUsageCommand('TeX');
	$u->setDescription('\\TeX と表示するコマンドです。');
	return $u;
}

function command__La_Te_X_call(){
	return '<img src="'.MIL_URL.'images/LaTeX.png" alt="LaTeX" title="LaTeX" />';
}

function command__La_Te_X_usage(){
	$u = new MilUsageCommand('LaTeX');
	$u->setDescription('\\LaTeX と表示するコマンドです。');
	return $u;
}

function command_tex_call($args, $parser){
	if(count($args) < 1){
		throw new InvalidArgumentCountException();
	}
	$tex = preg_replace('/\\s*\\r?\\n\\s*/s', ' ', $args[0]);
	$tex = trim($tex);
	$tex = tex($tex, $parser);
	return $tex;
}

function command_tex_usage(){
	$u = new MilUsageCommand('tex');
	$u->setDescription('引数を \\TeX ソースコードとして処理し、表示します。');
	$u->setArgument('{ src }', array('src'=>'処理したい \\TeX ソースコード'));
	$u->addExample('\\tex{Amp\\`ere} の法則');
	return $u;
}

function environment_tex_call($main_arg, $args, $parser){
	$tex = preg_replace('/\\s*\\r?\\n\\s*/s', ' ', $main_arg);
	$tex = trim($tex);
	$tex = tex($tex, $parser);
	return $tex;
}

function environment_tex_usage(){
	$u = new MilUsageEnvironment('tex');
	$u->setDescription('引数を \\TeX ソースコードとして処理し、表示します。');
	$u->setArgument('処理したい \\TeX ソースコード');
	return $u;
}

function environment_eqnarray_call($main_arg, $args, $parser){
	$exp = preg_replace('/\\s*\\r?\\n\\s*/s', ' ', $main_arg);
	$exp = trim($exp);
	$eqn = tex('\\begin{eqnarray*} '.$exp.' \\end{eqnarray*}', $parser);
	return equation_output($eqn, @$args[0], $parser);
}

function environment_eqnarray_usage(){
	$u = new MilUsageEnvironment('eqnarray');
	$u->setDescription('\\TeX の eqnarray 環境と同等です。');
	$u->setArgument('行揃えを 「&」 で、改行を 「\\\\\\\\」 で表します。');
	$u->addExample('
		\\begin{eqnarray}
			ax^2 + bx + c & = & 0 \\\\
			x & = & \\frac{-b \pm \sqrt{b^2 -4ac}}{2a}
		\\end{eqnarray}
	');
	return $u;
}

function tex($content){
	$q = urlencode(html_entity_decode($content));
	$content = str_replace(array('\\',"\r\n"), array('\\\\',' '), $content);
	return '<img src="'.TEX2PNG.'?q='.$q.'" alt="'.$content.'" title="'.$content.'" />';
}

?>
