<?php

/*---------- configurations ----------*/
// clean?
define('CLEAN_TMP_DIR', true);
// error message
define('ERROR_FONT', 3);
define('ERROR_TAB_SIZE', 2);
define('ERROR_BACKGROUND_COLOR_R', 0xff);
define('ERROR_BACKGROUND_COLOR_G', 0xff);
define('ERROR_BACKGROUND_COLOR_B', 0xff);
define('ERROR_TEXT_COLOR_R', 0xff);
define('ERROR_TEXT_COLOR_G', 0x00);
define('ERROR_TEXT_COLOR_B', 0x00);

// dir
define('TMP_DIR', dirname(__FILE__).'/tmp/');
define('CACHE_DIR', dirname(__FILE__).'/cache/');

// default equation style
// $styles = array('displaystyle', 'textstyle', 'scriptstyle', 'scriptscriptstyle');
// define('DEFAULT_EQUATION_STYLE', 'displaystyle');

// tex file
define(
'TEX_HEADER',
<<<EOM
\\documentclass[12pt]{jarticle}

\\usepackage{amsmath, amssymb}
\\usepackage{bm}
\\usepackage{cases}

\\DeclareMathOperator{\\rank}{rank}
\\DeclareMathOperator{\\rot}{rot}
\\DeclareMathOperator{\\grad}{grad}

\\begin{document}

\\thispagestyle{empty}

EOM
);
define(
'TEX_FOOTER',
<<<EOM

\\end{document}

EOM
);

// platex options
define('PLATEX_OPTIONS', '-kanji=utf8');

// dvipng options
define('DVIPNG_OPTIONS', '-T tight -bd 1000 --freetype0 -Q 5 --gamma 1.5');

// cache expire
define('USE_CACHE_EXPIRE', false);
define('CACHE_EXPIRE', 60*60*24*7);

$allow_list = array(
	'127.0.0.1',
	'192.168.0.10',
	'192.168.0.30'
);

/*---------- configurations ----------*/

function phptexpng($code){
	// 指定がなければ
	if($code == null){
		imagepng(get_error_exit_image(array(
			'Error :',
			'Expression not specified'
		)));
		return;
	}
	
	$fnm = exp2fnm($code);
	
	// キャッシュがあるかチェック
	if(file_exists(CACHE_DIR.$fnm.'.png')){
		readfile(CACHE_DIR.$fnm.'.png');
		return;
	}
	
	$fnm_tmp = exp2fnm($code.mt_rand());
	
	// clean tmp dir
	clean($fnm_tmp);
	
	// make tex-source
	$file = @fopen(TMP_DIR.$fnm_tmp.'.tex', 'w');
	if($file == null){
		imagepng(get_error_exit_image(array(
				'Error :',
				'Cannot create tex file'
		)));
		clean($fnm_tmp);
		return;
	}
	
	fwrite($file, TEX_HEADER);
	fwrite($file, $code);
	fwrite($file, TEX_FOOTER);
	fclose($file);
	
	// convert tex to dvi
	exec('platex -output-directory='.TMP_DIR.' '.PLATEX_OPTIONS.' '.TMP_DIR.$fnm_tmp.'.tex');
	
	// if $fnm_tmp.dvi does not exist
	if(!file_exists(TMP_DIR.$fnm_tmp.'.dvi')){
		imagepng(get_error_exit_image(array(
				'Error :',
				'Cannot convert tex to dvi',
				'Please check the expression'
		)));
		clean($fnm_tmp);
		return;
	}
	
	// convert dvi to png
	exec('dvipng -o '.TMP_DIR.$fnm_tmp.'.png '.DVIPNG_OPTIONS.' '.TMP_DIR.$fnm_tmp.'.dvi');
	
	// if $fnm_tmp.png does not exist
	if(!file_exists(TMP_DIR.$fnm_tmp.'.png')){
		imagepng(get_error_exit_image(array(
			'Error :',
			'Cannot convert dvi to png'
		)));
		clean($fnm_tmp);
		return;
	}
	
	// move TMP_DIR/$fnm_tmp.png to CACHE_DIR/$fnm.png
	if(rename(TMP_DIR.$fnm_tmp.'.png', CACHE_DIR.$fnm.'.png') == false){
		imagepng(get_error_exit_image(array(
				'Error :',
				'Cannot move png to cache directory'
		)));
		clean($fnm_tmp);
		return;
	}
	// clean if succeeded
	clean($fnm_tmp);
	
	// success
	readfile(CACHE_DIR.$fnm.'.png');
	return;
}
	
function get_error_exit_image($msg, $fnm = null){
	// get font size
	$font_width = imagefontwidth(ERROR_FONT);
	$font_height = imagefontheight(ERROR_FONT);
	// determine image size
	$image_height = $font_height * count($msg);
	$tmp = 0;
	$i = 0;
	foreach($msg as $value){
		$length = strlen($value) + ERROR_TAB_SIZE * $i;
		if($tmp < $length)
			$tmp = $length;
		$i++;
	}
	$image_width = $font_width * $tmp;
	// create image
	$img = imagecreate($image_width, $image_height);
	// set background color
	imagecolorallocate($img, ERROR_BACKGROUND_COLOR_R, ERROR_BACKGROUND_COLOR_G, ERROR_BACKGROUND_COLOR_B);
	// set error text color
	$tcolor = imagecolorallocate($img, ERROR_TEXT_COLOR_R, ERROR_TEXT_COLOR_G, ERROR_TEXT_COLOR_B);
	// draw string
	$i = 0;
	foreach($msg as $value){
		imagestring($img, ERROR_FONT, $i * $font_width * ERROR_TAB_SIZE, $i * $font_height, $value, $tcolor);
		$i++;
	}
	return $img;
}

function clean($fnm){
	if(!CLEAN_TMP_DIR)
		return;
	// clean tmp directory
	@unlink(TMP_DIR.$fnm.'.tex');
	@unlink(TMP_DIR.$fnm.'.log');
	@unlink(TMP_DIR.$fnm.'.aux');
	@unlink(TMP_DIR.$fnm.'.dvi');
	@unlink(TMP_DIR.$fnm.'.png');
	// clear cache if expired
	if(!USE_CACHE_EXPIRE)
		return;
	$cache_dir = @opendir(CACHE_DIR);
	if($cache_dir == null)
		return;
	$now = time();
	while(($fname = readdir($cache_dir)) !== false){
		if(preg_match('/.+\\.png/', $fname) == 0)
			continue;
		if($now - fileatime(CACHE_DIR.$fname) > CACHE_EXPIRE)
			unlink(CACHE_DIR.$fname);
	}
}

// To return safer filename, make sure that the filename has lower chance of collision
function exp2fnm($exp){
	return md5($exp).sha1($exp);
}

?>
