<?php

$begin = microtime(true);

define('SITE_NAME', 'try mil');

header('Content-type: text/html; charset=utf8');

require_once(dirname(__FILE__).'/mil//mil.php');

$source = @$_POST['s'];
if($source == null){
ob_start();
?>

\title{mil - テストページ}

ここでは mil コードを打って、実際に試すことができます。

ページ下部にテキストボックスがありますので、それを編集し、「変換」ボタンを押すことで、HTML への変換結果を見ることができます。

% 目次を表示します。
\tableofcontents

\chapter{数式}

\section{ガウス積分}
\begin{equation}
I = \int_{-\infty}^\infty e^{-x^2} dx = \sqrt{\pi}
\end{equation}

\section{正規分布}
\begin{equation}
f(x) = \frac{1}{\sqrt{2\pi}\sigma} e^{-\frac{1}{2} \left( \frac{x-\mu}{\sigma} \right)^2 }
\end{equation}

\section{ローレンツ変換}
\begin{equation}
\left(\begin{array}{c}
ct' \\ x'
\end{array}\right) = \gamma
\left(\begin{array}{cc}
1 & -\beta \\
-\beta & 1 \\
\end{array}\right)
\left(\begin{array}{c}
ct \\ x
\end{array}\right)
\end{equation}

\chapter{文字装飾}

\section{色付け}
\color{red}{赤}\color{green}{緑}\color{blue}{青}

\section{フォントスタイル}
\textit{斜体}
\textbf{太字}
\sout{取り消し線}

\section{文字サイズ}
\tiny{tiny}\br
\scriptsize{scriptsize}\br
\footnotesize{footnotesize}\br
\small{small}\br
\normalsize{normalsize}\br
\large{large}\br
\Large{Large}\br
\LARGE{LARGE}\br
\huge{huge}\br
\Huge{Huge}

\chapter{その他}

\section{注釈}
注釈を\footnote{注釈は、\\chapter コマンドや \\section コマンドが呼ばれたときに出力されます。ページの最後でも出力されます。また \\theendnotes コマンドで任意の場所に注釈を出力することもできます}こんな風につけることができます。

\section{リンク}
\url{http://google.com/}{Google}{泣く子も黙る検索サイト}

<?php
$source = ob_get_clean();
}

$result = mil_convert($source, false);

?>
<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="ja">
	<head>
		<link rel="stylesheet" type="text/css" href="./mil/css.php" />
		<link rel="stylesheet" type="text/css" href="./csses/style.css" />
		<title><?php echo $result->getTitle(); ?> - <?php echo SITE_NAME; ?></title>
	</head>
	<body>
		<div class="header">
			<table style="width:100%;"><tr>
				<td class="sitename">
					<a href="./try.php" title="milを試す"><?php echo SITE_NAME; ?></a>
				</td>
				<td style="text-align:right;">
				 [ <a href="./">Top</a> ]
				</td>
			</tr></table>
		</div>
		<hr />
		<p style="text-align:center;">
			このページは mil により生成されました。<br />
			mil の詳細は、<a href="./">トップページ</a>をご覧ください。
		</p>
		<hr />
		<div class="body">
			<div class="html">
				<?php echo $result->result(); ?>
			</div>
			<hr />
			<div class="source">
				<div title="上のソースです" style="font-size:150%;text-align:center;">ソースコード</div>
				<br />
				<form action="./try.php" method="post">
<textarea name="s" style="width:100%;height:400px;"><?php echo $source; ?></textarea>
					<div style="text-align:center;">
						<input type="reset" value="元に戻す" />
						<span style="margin-left:3em;visibility:hidden;"></span>
						<input type="submit" value="変換" />
					</div>
				</form>
			</div>
		</div>
		<div class="footer">
			<hr />
			<table style="width:100%;"><tr><td>
				Convert time : <?php printf('%.2f', (microtime(true)-$begin)*1000); ?> ms.<br />
				mil <?php echo MIL_VERSION; ?> - Copyright © <a href="http://mil.sourceforge.jp/?p=about/developer">mil developers team</a> 2009 all rights reserved.<br />
			Powered by <?php echo PHP_VERSION; ?>.
			</td><td style="text-align:right;">
					<a href="http://sourceforge.jp/"><img src="http://sourceforge.jp/sflogo.php?group_id=4288&type=1" style="width:96px;height:31px;border:0px;" alt="SourceForge.JP" title="このプロジェクトは SourceForge.JP により支援されています"></a>
			</td></table>
		</div>
	</body>
</html>

