/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2008-2011  Kouhei Sutou <kou@clear-code.com>
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __MILTER_MANAGER_TEST_UTILS_H__
#define __MILTER_MANAGER_TEST_UTILS_H__

#include <gcutter.h>
#include "milter-test-compatible.h"

#include <milter/core.h>

G_BEGIN_DECLS

void         milter_manager_test_wait_signal (MilterEventLoop *loop,
                                              gboolean         should_timeout);

typedef struct _MilterManagerTestPair
{
    gchar *name;
    gchar *value;
} MilterManagerTestPair;

MilterManagerTestPair   *milter_manager_test_pair_new
                                        (const gchar *name,
                                         const gchar *value);
void                     milter_manager_test_pair_free
                                        (MilterManagerTestPair *pair);
void                     milter_manager_test_pair_inspect
                                        (GString *string,
                                         gconstpointer pair,
                                         gpointer user_data);
gboolean                 milter_manager_test_pair_equal
                                        (gconstpointer pair1,
                                         gconstpointer pair2);
gint                     milter_manager_test_pair_compare
                                        (gconstpointer pair1,
                                         gconstpointer pair2);

void                     milter_manager_test_defined_macros_inspect
                                        (GString *string,
                                         gconstpointer defined_macros,
                                         gpointer user_data);
gboolean                 milter_manager_test_defined_macros_equal
                                        (gconstpointer pair1,
                                         gconstpointer pair2);

gboolean                 milter_manager_test_applicable_condition_equal
                                        (gconstpointer condition1,
                                         gconstpointer condition2);

gboolean                 milter_manager_test_egg_equal
                                        (gconstpointer egg1,
                                         gconstpointer egg2);

G_END_DECLS

#endif /* __MILTER_MANAGER_TEST_UTILS_H__ */

/*
vi:ts=4:nowrap:ai:expandtab:sw=4
*/
