/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#ifndef NYLPC_CSYNCPROC_H_
#define NYLPC_CSYNCPROC_H_


typedef struct NyLPC_TcSyncProc NyLPC_TcSyncProc_t;

#include "NyLPC_stdlib.h"
#include "NyLPC_cSyncCall.h"

/**********************************************************************
 *
 * NyLPC_TcSyncProc
 *
 **********************************************************************/
#if NyLPC_ARCH==NyLPC_ARCH_FREERTOS

/**
 * NyLPC_TcSyncProcクラスのメンバ変数を定義する構造体です。
 * NyLPC_cSyncProc_initialize関数で初期化してから使います。
 */
struct NyLPC_TcSyncProc
{
	xSemaphoreHandle _q;
	NyLPC_TcSyncCall_t* _last_caller;
};

/**
 * クラスのイニシャライザです。
 */
NyLPC_TBool NyLPC_cSyncProc_initialize(NyLPC_TcSyncProc_t* i_inst);
/**
 * この関数は、NyLPC_TcSyncCallの呼び出しと待ち合わせをします。
 * 関数の一時的な同期処理を記述するときに使います。
 * 関数は、i_wait_tickで指定した時間、NyLPC_TcSyncCallからのコールを待ち、コールがあったかを戻り値に返します。
 * 成功すると、呼び出し元のNyLPC_TcSyncCallはブロックします。
 * 通常は、以下のように、NyLPC_cSyncProc_waitCallセットで使います。
 * <pre>
 * 	void* p;
 * 	if(NyLPC_cSyncProc_waitCall(i_inst,&p,10)){
 * 		//:
 * 		NyLPC_cSyncProc_returnCall(i_inst);
 * }
 * </pre>
 * \param i_inst
 * インスタンスを指定します。
 * \param　o_msg
 * メッセージポインタを受け取るポインタを指定します。
 * \param i_wait_tick
 * 待ち時間をtick単位で指定します。
 * \return
 * 同期が行われたかを返却します。
 */
NyLPC_TBool NyLPC_cSyncProc_waitCall(NyLPC_TcSyncProc_t* i_inst,void** o_msg,NyLPC_TUInt32 i_wait_msec);
/**
 *
 */
void NyLPC_cSyncProc_returnCall(NyLPC_TcSyncProc_t* i_inst);


#elif NyLPC_ARCH==NyLPC_ARCH_WIN32
#else
#error Bad NyLPC_ARCH!
#endif


#endif /* NYLPC_CSYNCPROC_H_ */
