/*
 * This is part of EthDev_LPC17xx.h
 */

#ifndef EtherDev_LAN8720_protected_h
#define EtherDev_LAN8720_protected_h

#include "EtherDev_LAN8720.h"

#define LAN8720_ID          0x0007C0F0  /* PHY Identifier                    */

/* LAN8720 PHY Registers */
#define PHY_REG_BMCR        0x00        /* Basic Mode Control Register       */
#define PHY_REG_BMSR        0x01        /* Basic Mode Status Register        */
#define PHY_REG_IDR1        0x02        /* PHY Identifier 1                  */
#define PHY_REG_IDR2        0x03        /* PHY Identifier 2                  */
#define PHY_REG_ANAR        0x04        /* Auto-Negotiation Advertisement    */
#define PHY_REG_ANLPAR      0x05        /* Auto-Neg. Link Partner Abitily    */
#define PHY_REG_ANER        0x06        /* Auto-Neg. Expansion Register      */

/* PHY Extended Registers */
#define	PHY_REG_MODE_CTRL	    17
#define	PHY_REG_SPECIAL_MODE	18
#define	PHY_REG_SYMBOL_ERR_CNT	26
#define	PHY_REG_SPECIAL_CTRL	27
#define	PHY_REG_INT_SOURCE	    29
#define	PHY_REG_INT_MASK	    30
#define	PHY_REG_PHY_CTRL	    31

#define PHY_AUTO_NEG        	0x3000  /* Select Auto Negotiation           */
#define PHY_AUTO_NEG_COMPLETE 	0x1000	/* Auto negotiation have finished.   */

#define PHY_SPEED_FDUPLX 		0x0010	/* Full Duplex   */
#define PHY_SPEED_100	 		0x0008	/* 100Mbit   */
#define ETHDEV_PHY_DEF_ADR		0x0100  /* Default PHY device address        */


#endif
