/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/
#include "NyLPC_cHttpShortRequestHeaderParser.h"

static NyLPC_TBool message_handler(NyLPC_TcHttpBasicHeaderParser_t* i_inst,const NyLPC_TChar* i_name,NyLPC_TChar i_c,struct NyLPC_THttpBasicHeader* o_out)
{
	(void)i_inst;
	(void)i_name;
	(void)i_c;
	return NyLPC_TBool_TRUE;
}
static NyLPC_TBool urlHandler(NyLPC_TcHttpBasicHeaderParser_t* i_inst,NyLPC_TChar i_c,struct NyLPC_THttpBasicHeader* o_out)
{
	//32文字までのURL解析
	NyLPC_TcHttpShortRequestHeaderParser_t* inst=(NyLPC_TcHttpShortRequestHeaderParser_t*)i_inst;
	struct NyLPC_THttpShortRequestHeader* out=(struct NyLPC_THttpShortRequestHeader*)o_out;
	out->url[inst->url_len]=i_c;
	inst->url_len++;
	if(inst->url_len>=32){
		return NyLPC_TBool_FALSE;
	}
	return NyLPC_TBool_TRUE;
}
/**
 * デフォルトハンドラ
 */
static const struct NyLPC_TcHttpBasicHeaderParser_Handler _handler=
{
	message_handler,
	urlHandler
};




void NyLPC_cHttpShortRequestHeaderParser_initialize(NyLPC_TcHttpShortRequestHeaderParser_t* i_inst)
{
	NyLPC_cHttpBasicHeaderParser_initialize(&(i_inst->super));
	i_inst->super._handler=&_handler;
}

NyLPC_TBool NyLPC_cHttpShortRequestHeaderParser_parse(NyLPC_TcHttpShortRequestHeaderParser_t* i_inst,NyLPC_TcHttpStream_t* i_stream,struct NyLPC_THttpShortRequestHeader* o_out)
{
	NyLPC_TcHttpShortRequestHeaderParser_t* inst=(NyLPC_TcHttpShortRequestHeaderParser_t*)i_inst;
	inst->url_len=0;
	return NyLPC_cHttpBasicHeaderParser_parse(&(i_inst->super),i_stream,&(o_out->super));
}


