/*********************************************************************************
 * PROJECT: MiMic
 * --------------------------------------------------------------------------------
 *
 * This file is part of MiMic
 * Copyright (C)2011 Ryo Iizuka
 *
 * MiMic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by　the Free Software Foundation, either version 3 of the　License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * For further information please contact.
 *	http://nyatla.jp/
 *	<airmail(at)ebony.plala.or.jp> or <nyatla(at)nyatla.jp>
 *
 *********************************************************************************/

#ifndef NyLPC_uipService_H
#define NyLPC_uipService_H
#include "NyLPC_cUipService.h"
#include "../driver/uip/EthDev.h"
#include "../driver/uip/EthDev_LPC17xx.h"

/**********************************************************************
 *
 * NyLPC_TcUipService_t
 *
 **********************************************************************/

#define NyLPC_TcUipService_SIZE_OF_REPLY_BUF 128


struct NyLPC_TcUipService
{
	const NyLPC_TcIPv4Config_t* _ref_config;
	NyLPC_TUInt16	_status;			/**< ステータスビット*/
	void*			_task_cmd;			/**< タスク操作用コマンド*/
	xSemaphoreHandle _emac_semapho;		/** EMACの制御用セマフォです。*/
	NyLPC_TcStopwatch_t _arp_sw;		/**<ARP用のストップウォッチ*/
	NyLPC_TcStopwatch_t _periodic_sw;	/**<周期実行用のストップウォッチ*/

	/** TCPv4処理インスタンス*/
	NyLPC_TcIPv4_t _tcpv4;
	/** ICOMP処理インスタンス*/
	NyLPC_TcIPv4IComp_t _icomp;
	/** 排他制御用*/
	NyLPC_TcMutex_t _mutex;
	const struct TiEthernetDevice* _ethif;
	/**　ipタスクが使う小サイズ送信バッファ*/
	struct
	{
		struct NyLPC_TTxBufferHeader h;
		NyLPC_TUInt8 buf[NyLPC_TcUipService_SIZE_OF_REPLY_BUF];
	}stx;
};


/**　唯一のサービスインスタンス - Single service instance*/
extern NyLPC_TcUipService_t* _NyLPC_TcUipService_inst;

/**
 * サービスが初期化済みならtrueです。 - true if service was initialized.
 */
#define NyLPC_TcUipService_isInitService() (_NyLPC_TcUipService_inst!=NULL)
/**
 * サービスが稼働中か返します。
 */
#define NyLPC_cUipService_isRun() NyLPC_TUInt16_isBitOn(_NyLPC_TcUipService_inst->_status,NyLPC_TcUipService_STATUS_RUN)


/**********************************************************************
 * コントロールビットの定義
 **********************************************************************/
//サービスは実行中
#define NyLPC_TcUipService_STATUS_RUN		0x0001
//サービスは停止中
#define NyLPC_TcUipService_STATUS_STOP		0x0002



#define INST_TYPE_NyLPC_Unknown 0
#define INST_TYPE_NyLPC_TcTcpListener 1
#define INST_TYPE_NyLPC_TcTcpSocket 2


/**********************************************************************
 * cTcpSocketからコールする関数
 **********************************************************************/



/**
 * IPv4パケットをネットワークに送信します。
 * この関数は、リエントラントを許容します。
 * @param i_eth_payload
 * NyLPC_cUipService_getTxFrame、または、NyLPC_cUipService_recvIPv4Rxで得たバッファに、
 * IPv4パケットを書きこんだものを指定してください。
 */
void NyLPC_cUipService_sendIPv4Tx(void* i_eth_payload);

/**
 * 送信ペイロードメモリを返します。
 * この関数は、リエントラントを許容します。
 * 取得したメモリは、releaseTxBufで必ず開放してください。
 * @param i_hint
 * 取得したいメモリサイズを指定します。(このサイズは、イーサネットヘッダのサイズを含みません。)
 * このサイズよりも小さなサイズが割り当てられることがあります。
 */
void* NyLPC_cUipService_allocTxBuf(NyLPC_TUInt16 i_hint,NyLPC_TUInt16* o_size);

/**
 * allocTxbufで確保したメモリを開放します。
 */
void* NyLPC_cUipService_releaseTxBuf(void* i_buf);

void NyLPC_cTcpSocket_periodic(
	NyLPC_TcTcpSocket_t* i_inst);
#endif
