/*
 * native_function.c
 *
 *  Created on: 2011/11/12
 *      Author: nyatla
 */
#include "native_function.h"

/**
 * This function is sample of Native function call.
 * You can call function from MiMicIL editor.
 * <pre>
 * ;MiMicIL example
 * CALL 0x39000000
 * EXIT
 * .END
 * .D32 0x3939
 * </pre>
 * The result stream is [0x3939]
 */
static NyLPC_TBool jp_nyatla_native_sample(NyLPC_TcMiMicVM_t* i_vm);

static NyLPC_TBool jp_nyatla_native_sample2(NyLPC_TcMiMicVM_t* i_vm);


/**
 * Native function table.
 */
const struct TNativeFunctionItem naitive_function_table[]=
{
	{0x39000000,"jp.nyatla.native_sample",jp_nyatla_native_sample},
	{0x39000001,"jp.nyatla.native_sample2",jp_nyatla_native_sample2},
	//
	// add your native function here!
	//
	{0x39FFFFFF,NULL,NULL} //This is terminator.
};


////////////////////////////////////////////////////////////////////////////////
// public functions
////////////////////////////////////////////////////////////////////////////////


/**
 * 関数さがす
 */
NyLPC_TNativeFunction getNativeFunctionById(NyLPC_TUInt32 i_id)
{
	int i;
	for(i=0;naitive_function_table[i].function!=NULL;i++){
		if(i_id==naitive_function_table[i].id){
			return naitive_function_table[i].function;
		}
	}
	return NULL;
}

////////////////////////////////////////////////////////////////////////////////
// native functions
////////////////////////////////////////////////////////////////////////////////

/**
 * この関数はネイティブインタフェイスのサンプルです。i_vmのストリームから32bit値を1個読み出して、そのままエコーバックします。
 * VMのワークメモリの操作、VMの持つストリームの操作が出来ます。
 */
NyLPC_TBool jp_nyatla_native_sample(NyLPC_TcMiMicVM_t* i_vm)
{
	NyLPC_TUInt32 v;

	//read uint32 value from stream.
	if(!NyLPC_cMiMicVM_sget(i_vm,&v)){
		return NyLPC_TBool_FALSE;
	}

	//you can access VM work memory.
	//i_vm.wm[0],i_vm.wm[1]...i_vm.wm[NyLPC_TcMiMicVM_NUMBER_OF_WM-1]

	//write your native code here.
	v=v+39;
	v=v-39;

	//write uint32 value from stream.
	if(!NyLPC_cMiMicVM_sput(i_vm,v)){
		return NyLPC_TBool_FALSE;
	}
	return NyLPC_TBool_TRUE;//OK
}
NyLPC_TBool jp_nyatla_native_sample2(NyLPC_TcMiMicVM_t* i_vm)
{
	i_vm->wm[0]++;
	return NyLPC_TBool_TRUE;//OK
}
