//: <html>
//: <head><title>SoupProject::MiX::sample::xmlpb</title>
//: <link rel="stylesheet" href="../default.css" type="text/css"/></head>
//: <body>
//: <h1>SoupProject::MiX</h1>
//: <h2>db - SAXɂ</h2>
//: <p>
//: dbSAXpĎĂ݂܂傤B<br>
//: ꉞʃy[WDOMɂĂ܂Â悤ȒP
//: vOłSAX̂قyɃVvɎłł傤B<br>
//: (ǂޑOxml2html̍ǂłقł傤B)
//: <pre>
#include <MiX/SAX_Parser.h>

#include <iostream>
#include <fstream>
#include <string>
#include <utility>
#include <iterator>
//: </pre><p>
//: ܂Kvȃwb_CN[h܂B<br>
//: SAXgꍇMiX/SAX_Parser.hinclude΁AKvȂׂ̂include
//: ܂B
//: </p><pre>
typedef std::map<std::string,std::string> PhoneBook;
typedef std::pair<std::string,std::string> Person;
//: </pre><p>
//: db̗vf\Person^ƁAdb\PhoneBook^`܂B<br>
//: Person^͖OƓdbԍi[pairŁAPhoneBookPersonlistłB
//: </p><pre>
std::string input(const char* prompt){
  std::string ret;
  std::cout << prompt << ": " << std::flush;
  std::cin >> ret;
  return ret;
}
//: </pre><p>
//: Wo͂ɃvvgoĕW͂sǂݎ֐łB
//: </p><pre>
void outputPerson(const Person& per){
  std::cout << per.first << " : " << per.second << std::endl;
}
//: </pre><p>
//: Persono͂֐łB<br>
//: </p><pre>
class EventHandler : public MiX::SAX_EventHandler<char>{
//: </pre><p>
//: SAXgŌȂASAX̃Cxg󂯎nh`܂B<br>
//: XMLPhoneBookIuWFNg𐶐Ă܂B
//: </p><pre>
  PhoneBook& pb_;
  Person cur_;
  std::string str_;
//: </pre><p>
//: PhoneBookɕKvȕϐ`Ă܂B
//: <ul class="top">
//: <li>pb_</li>
//: <blockquote>
//: PhoneBookւ̎QƂł
//: </blockquote>
//: <li>cur_</li>
//: <blockquote>
//: PersonIuWFNgi[܂
//: </blockquote>
//: <li>str_</li>
//: <blockquote>
//: 擾ꎞi[Ă܂
//: </blockquote>
//: </ul>
//: </p><pre>
public:
  EventHandler(PhoneBook& pb) : pb_(pb){
  }
//: </pre><p>
//: PhoneBookւ̎QƂnEventHandler܂B
//: </p><pre>
  void onStart(MiX::XMLString<char> name,MiX::AttrMap<char> attr){
    str_="";
  }
//: </pre><p>
//: ^OJnĂяonhłB<br>
//: łstr_Ă邾łB
//: </p><pre>
  void onText(MiX::XMLString<char> text){
    str_+=text;
  }
//: </pre><p>
//: XML̕oɌĂяonhłB<br>
//: str_ɕĂ܂B
//: </p><pre>
  void onEnd(MiX::XMLString<char> name){
    if(name=="Person") pb_.insert(cur_);
    else if(name=="Name") cur_.first = str_;
    else if(name=="Phone") cur_.second = str_;
  }
//: </pre><p>
//: ^OIɌĂяonhłB<br>
//: ŎȏsĂ܂B<br>
//: I^OName^Ocur_firststr_i[B<br>
//: I^OPhone^OȂcur_secondstr_i[B<br>
//: Person^OȂcur_pb_ɒǉ܂B<br>
//: ̂悤ɂpb_܂B
//: </p><pre>
};

void storeFile(const char* fn,const PhoneBook& pb){
  std::ofstream fout(fn);
  fout << "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" << std::endl
       << "<PhoneBook>";
  PhoneBook::const_iterator it = pb.begin();
  PhoneBook::const_iterator last = pb.end();
  for( ;it!=last;++it){
    fout << "\t<Person>" << std::endl
	 << "\t\t<Name>" << it->first << "</Name>" << std::endl
	 << "\t\t<Phone>" << it->second << "</Phone>" << std::endl
	 << "\t</Person>" << std::endl;
  }
  fout << "</PhoneBook>" << std::endl;
  fout.close();
}
//: </pre><p>
//: PhoneBookXMLɂăt@Cɏo͂֐łB<br>
//: SAX̏ꍇAXML̉͂͂ł܂AXML̏o͂͂łȂ̂ŁÂ悤
//: ŏo̓vOĂKv܂B
//: </p><pre>
int main(){
  PhoneBook pb;
  std::ifstream fin("phonebook.xml");
  if(fin.is_open()) {
    EventHandler handler(pb);
    MiX::SAX_Parser<char> parser;
    parser.setEventHandler(&handler);
    parser.setIgnoreSpace(true);
    parser.parse(fin);
  }
//: </pre><p>
//: t@C΁At@Cp[XāAPhoneBookIuWFNg𐶐܂B
//: <br>t@CȂ΁APhoneBookIuWFNĝ܂܏܂B
//: </p><pre>
  char cmd = '\0';
  while(cmd!='q'){
    std::string s = input("add/delete/find/list/clear/quit [a,d,f,l,c,q]");
    cmd = s.at(0);
//: </pre><p>
//: &apos;q&apos;R}h͂܂ŃR}h[vJԂ܂
//: </p><pre>
    switch(cmd){
    case 'a' : case 'A' : {
      std::string name = input("Name");
      if(pb.find(name) != pb.end()) 
	std::cerr << "error: already exists." << std::endl;
      else {
	std::string phone = input("Phone");
	pb.insert(Person(name,phone));
      }
      break;
    }
//: </pre><p>
//: &apos;a&apos;͂ꂽꍇAPhoneBookɐVPersonǉ܂B<Br>
//: O󂯎āA̖OPersonɓo^Ăꍇ
//: G[o܂B<br>
//: ݂ȂΓdbԍ󂯎PersonIuWFNg𐶐Apbɒǉ܂B
//: </p><pre>
    case 'd' : case 'D' : {
      std::string name = input("Name");
      PhoneBook::iterator it =  pb.find(name);
      if(it==pb.end()) 
	std::cerr << "error: not found." << std::endl;
      else pb.erase(it);
      break;
    }
//: </pre><p>
//: &apos;d&apos;͂ꂽꍇA͂ꂽOPerson폜܂B<br>
//: O󂯎āApb炻̖OIuWFNgA
//: Ȃꍇ̓G[oAꍇ͂Person폜܂B
//: </p><pre>
    case 'f' : case 'F' : {
      std::string name = input("Name");
      PhoneBook::iterator it = pb.find(name);
      if(it==pb.end()) 
	std::cerr << "error: not found." << std::endl;
      else outputPerson(*it);
      break;
    }
//: </pre><p>
//: &apos;f&apos;͂ꂽAOPersonāA
//: Person\܂B<br>
//: O󂯎āApb炻̖OIuWFNgA
//: Ȃꍇ̓G[oAꍇ͂Persono͂܂B
//: </p><pre>
    case 'l' : case 'L' : {
      std::cout << pb.size() << "entries:" << std::endl;
      std::for_each(pb.begin(),pb.end(),outputPerson);
      break;
    }
//: </pre><p>
//: &apos;l&apos;͂ꂽ́ASPerson\܂B<br>
//: ostream_iteratorgđSPersono͂Ă܂B
//: </p><pre>
    case 'c' : case 'C' : {
      pb.clear();
      break;
    }
//: </pre><p>
//: &apos;c&apos;͂ꂽ͑SPerson폜܂B
//: </p><pre>
    // I
    case 'q' : case 'Q' : 
    default :
      break;
    }
  }
  storeFile("phonebook.xml",pb);
//: </pre><p>
//: IOpbt@Cɏo͂܂B
//: </p><pre>
}

