// -*- mode: c++ -*-

#ifndef MiX_COMMENT_H_
#define MiX_COMMENT_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NodeList.h"
#include "Value.h"
#include "extern/noncopyable.hpp"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class Comment : boost::noncopyable,
		  public Value<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Comment<charT,char_traits,xml_traits> this_type;
    typedef NodeContainer<charT,char_traits,xml_traits> nodecontainer_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^.
     *
     * Comment̃RXgN^͒ڌĂׂ܂<br>
     * Comment<...>::createŐĂ
     */
    Comment(const string_type& val) : Value<charT,char_traits,xml_traits>(val) { };
    /**
     * Rs[RXgN^
     *
     * Comment̓Rs[ł܂B
     */
    Comment(const this_type& src){ };

  public:
    ///fXgN^
    virtual ~Comment()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const { return Node_Comment; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_CommentԂ܂
     */
    static NodeType type() { return Node_Comment; } ;
    /**
     * Comment̕\𓾂܂
     *
     * bIndent^Ȃ當iIndentOffsetɎw肳ꂽ
     * XMLTraits::tab()߂l̐擪ɂ܂
     */
    virtual string_type toString(bool is_indent=false,int indent_off=0)const;
    /**
     * Comment𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    node_type& clone(nodecontainer_type& parent,const nodelist_iter& it = dmy_it) const 
      { return create(getValue(),dynamic_cast<element_type&>(parent),it); }
    /**
     * Comment𐶐܂
     *
     * <dl>
     *   <dt>str</dt><dd>Comment̒l</dd>
     *   <dt>parent</dt><dd>Comment̐eGg</dd>
     *   <dt>it</dt><dd>}ꏊparent.getChilds()̗vfCe[^łȂ΂Ȃ܂</dd>
     * </dl>
     */
    static this_type& create(const string_type& str,element_type& parent,const typename nodelist_type::iterator& it = dmy_it);

    friend class DOM_Parser<charT,char_traits,xml_traits>;

  };
}

#ifndef MiX_COMMENT_CPP_
#include "Comment.cpp"
#endif

#endif
