#define MIX_NODE_CPP_

#include <algorithm>
#include "XMLString.h"
#include "NodeList.h"
#include "Node.h"
#include "DOM_Exception.h"

namespace MiX{
  template <class charT,class char_traits,class xml_traits>
  Node<charT,char_traits,xml_traits>::~Node()throw(){
    if(parent_){
      nodelist_type& l=parent_->getChildren();
      typename nodelist_type::iterator it = std::find(l.begin(),l.end(),this);
      if(it != l.end()){
	parent_->getChildren().erase(it);
      }
      parent_ = 0;
    }
  };
  
  template <class charT,class char_traits,class xml_traits>
  const NodeContainer<charT,char_traits,xml_traits>& Node<charT,char_traits,xml_traits>::getParent()const{
    if(parent_ == 0){
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__ << std::endl
	 << "Parent not found." << std::endl << std::ends;
      throw dom_exception_type(this,NullException,ss.str());
    }
    return *parent_;
  };
  
  template <class charT,class char_traits,class xml_traits>
  NodeContainer<charT,char_traits,xml_traits>& Node<charT,char_traits,xml_traits>::getParent(){
    if(parent_ == 0){
      std::ostringstream ss;
      ss << "DOM_Exception" << std::endl
	 << __FILE__ << ':' << __LINE__ << std::endl
	 << "Parent not found." << std::endl << std::ends;
      throw dom_exception_type(this,NullException,ss.str());
    }
    return *parent_;
  };
}
