//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

//CUPPA:namespace=+
//CUPPA:namespace=-

class AttributeTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(AttributeTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testCreate);
  CPPUNIT_TEST(testString);
  CPPUNIT_TEST(testClone);
  CPPUNIT_TEST(testOtherOps);
  CPPUNIT_TEST(testDestroy);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static MiX::Document<char>* doc_;
public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testCreate() {
    //[hLg
    // <?xml version="1.0" encoding="UTF-8"?>
    // <TestSuite name="DocumentTest">
    // <TestCase name="testCreate"/>
    // <TestCase name="testString"/>
    // <Description>This is test for MiX::Document</Description>
    // </TestSuite>
    doc_ = &(MiX::Document<char>::create("TestSuite"));
    CPPUNIT_ASSERT_EQUAL(doc_->getType(),MiX::Node_Document);
    MiX::Attribute<char>::create("version","1.0",*doc_);
    MiX::Attribute<char>::create("encoding","UTF-8",*doc_);
    MiX::Element<char>& el = doc_->getRoot();
    MiX::Attribute<char>::create("name","DocumentTest",el);
    MiX::Attribute<char>::create("name","testCreate",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Attribute<char>::create("name","testString",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Text<char>::create("This is test for MiX::Document",
			    MiX::Element<char>::create("Description",el));
  }
  void testString() {
    std::string data[] = {
      "version=\"1.0\"",
      "encoding=\"UTF-8\"",
      "name=\"DocumentTest\"",
      "name=\"testCreate\"",
      "name=\"testString\"",
    };
    CPPUNIT_ASSERT(data[0]==(*doc_)["version"].toString());
    CPPUNIT_ASSERT(data[1]==(*doc_)["encoding"].toString());
    CPPUNIT_ASSERT(data[2]==doc_->getRoot()["name"].toString());
    CPPUNIT_ASSERT(data[3]==doc_->getRoot()("TestCase",0)["name"].toString());
    CPPUNIT_ASSERT(data[4]==doc_->getRoot()("TestCase",1)["name"].toString());
  }
  void testClone() {
    const char data[] = {
      "<?xml version=\"1.0\" encoding=\"UTF-8\" version=\"1.0\"?>"
      "<TestSuite name=\"DocumentTest\" name=\"DocumentTest\">"
      "<TestCase name=\"testCreate\"/>"
      "<TestCase name=\"testString\"/>"
      "<Description>This is test for MiX::Document</Description>"
      "</TestSuite>"
    };
    (*doc_)["version"].clone(*doc_);
    doc_->getRoot()["name"].clone(doc_->getRoot());
    CPPUNIT_ASSERT(doc_->toString()==data);
  }
  void testOtherOps() {
    CPPUNIT_ASSERT((*doc_)["version"].getName()=="version");
    CPPUNIT_ASSERT((*doc_)["encoding"].getName()=="encoding");
  }
  void testDestroy() {
    doc_->destroy();
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

MiX::Document<char>* AttributeTest::doc_ = 0;

CPPUNIT_TEST_SUITE_REGISTRATION(AttributeTest);
