// -*- mode: c++ -*-
#ifndef MiX_ATTRIBUTE_H_
#define MiX_ATTRIBUTE_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NamedNode.h"
#include "Value.h"
#include "extern/noncopyable.hpp"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class Attribute : boost::noncopyable,
		    public Value<charT,char_traits,xml_traits> ,
		    public NamedNode<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Attribute<charT,char_traits,xml_traits> this_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^
     *
     * AttributẽRXgN^͒ڌĂׂ܂<br>
     * Attribute<...>::createŐĂ
     */
    Attribute(const string_type& name,const string_type ns,const string_type& val)
      : Value<charT,char_traits,xml_traits>(val),
	NamedNode<charT,char_traits,xml_traits>(name,ns){ };
    Attribute(const string_type& name,const string_type& val)
      : Value<charT,char_traits,xml_traits>(val),
	NamedNode<charT,char_traits,xml_traits>(name){ };
  public:
    ///fXgN^
    virtual ~Attribute()throw() { };
    ///̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const { return Node_Attribute; };
    /**
     * ÓIɃNXNodeType𓾂܂.
     *
     * Node_AttributeԂ܂
     */
    static NodeType type(){ return Node_Attribute; };

    string_type getFullName() const;
    /**
     * Attribute̕\𓾂܂.
     *
     * ͑SĖ܂
     */
    virtual string_type toString(bool dmy=false,int dmy2=0)const;

    /**
     * Attribute𕡐܂
     *
     *  \param parent ̐em[h
     */
    node_type& clone(nodecontainer_type& parent,const nodelist_iter& it=dmy_it) const
      { return create(getName(),getURL(),getValue(),parent); };

    /**
     * Attribute𐶐܂.
     *
     * \param key Attribute̖O
     * \param val Attribute̒l
     * \param parent Attribute̐em[h
     */
    static this_type& create(const string_type& key,const string_type& val,nodecontainer_type& parent) 
      { return this_type::create(key,string_type(),val,parent); }
    /**
     * Attribute𐶐܂.
     *
     * \param key Attribute̖O
     * \param ns Attribute̖OԂURL
     * \param val Attribute̒l
     * \param parent Attribute̐em[h
     */
    static this_type& create(const string_type& key,const string_type& ns,const string_type& val,nodecontainer_type& parent);
    
    friend class DOM_Parser<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_ATTRIBUTE_CPP_
#include "Attribute.cpp"
#endif

#endif
