//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"
//CUPPA:namespace=-

class FunctionsTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(FunctionsTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testTypeChecker);
  CPPUNIT_TEST(testNameChecker);
  CPPUNIT_TEST(testNamedNodeFinder);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  MiX::Document<char>* doc_;
public:

  virtual void setUp() {
    //[hLg
    // <?xml version="1.0" encoding="UTF-8"?>
    // <TestSuite name="DocumentTest">
    //   This is test for MiX::Document.
    //   <TestCase name="testCreate"/>
    //   <TestCase name="testString"/>
    //   <Description>This is test for MiX::Document</Description>
    //   <!-- -->
    //   <TestTarget type="MiX::Document" name="doc_"/>
    // </TestSuite>
    doc_ = &(MiX::Document<char>::create("TestSuite"));
    CPPUNIT_ASSERT_EQUAL(doc_->getType(),MiX::Node_Document);
    MiX::Attribute<char>::create("version","1.0",*doc_);
    MiX::Attribute<char>::create("encoding","UTF-8",*doc_);
    MiX::Element<char>& el = doc_->getRoot();
    MiX::Attribute<char>::create("name","DocumentTest",el);
    MiX::Text<char>::create("This is test for MiX::Document.",el);
    MiX::Attribute<char>::create("name","testCreate",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Attribute<char>::create("name","testString",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Comment<char>::create(" ",el);
    MiX::Element<char>& tar = MiX::Element<char>::create("TestTarget",el);
    MiX::Attribute<char>::create("type","MiX::Document",tar);
    MiX::Attribute<char>::create("name","doc_",tar);
  }
  virtual void tearDown() {
    doc_->destroy();
  }

//CUPPA:decl=+
  void testTypeChecker() {
    /*
      MiX::NodeTypeChecker<char> pred(MiX::Node_Comment);
    MiX::NodeList<char> lst = doc_->getRoot().getChildren();
    MiX::NodeList<char>::iterator it =std::find_if(lst.begin(),lst.end(),pred);
    CPPUNIT_ASSERT(it!=lst.end());
    MiX::Comment<char>& com = dynamic_cast<MiX::Comment<char>&>(**it);
    CPPUNIT_ASSERT(com.getValue()==" ");
    pred = MiX::NodeTypeChecker<char>(MiX::Node_Text);
    it = std::find_if(lst.begin(),lst.end(),pred);
    CPPUNIT_ASSERT(it!=lst.end());
    MiX::Text<char>& txt = dynamic_cast<MiX::Text<char>&>(**it);
    CPPUNIT_ASSERT(txt.getValue()=="This is test for MiX::Document.");
    */
  }
  void testNameChecker() {
    /*
      MiX::NodeNameChecker<char> pred("name");
    MiX::NodeList<char> lst = doc_->getRoot().getChildren();
    MiX::NodeList<char>::iterator it =std::find_if(lst.begin(),lst.end(),pred);
    CPPUNIT_ASSERT(it!=lst.end());
    CPPUNIT_ASSERT((*it)->getType()==MiX::Node_Attribute);
    MiX::Attribute<char>& att = dynamic_cast<MiX::Attribute<char>&>(**it);
    CPPUNIT_ASSERT(att.getName()=="name");
    CPPUNIT_ASSERT(att.getValue()=="DocumentTest");
    pred = MiX::NodeNameChecker<char>("TestTarget");
    it =std::find_if(lst.begin(),lst.end(),pred);
    CPPUNIT_ASSERT(it!=lst.end());
    CPPUNIT_ASSERT((*it)->getType()==MiX::Node_Element);
    MiX::Element<char>& el = dynamic_cast<MiX::Element<char>&>(**it);
    CPPUNIT_ASSERT(el.getName()=="TestTarget");
    CPPUNIT_ASSERT(el["type"].getValue()=="MiX::Document");
    CPPUNIT_ASSERT(el["name"].getValue()=="doc_");
    */
  }
  void testNamedNodeFinder() {
    MiX::NamedNodeFinder<MiX::Element<char> > pred("name");
    MiX::NodeList<char> lst = doc_->getRoot().getChildren();
    MiX::NodeList<char>::iterator it =std::find_if(lst.begin(),lst.end(),pred);
    CPPUNIT_ASSERT(it==lst.end());
    MiX::NamedNodeFinder<MiX::Attribute<char> > pred2("TestTarget");
    it =std::find_if(lst.begin(),lst.end(),pred2);
    CPPUNIT_ASSERT(it==lst.end());   
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(FunctionsTest);
