//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

//CUPPA:namespace=+
//CUPPA:namespace=-

class CommentTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(CommentTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testCreate);
  CPPUNIT_TEST(testString);
  CPPUNIT_TEST(testClone);
  CPPUNIT_TEST(testOtherOps);
  CPPUNIT_TEST(testDestroy);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  static MiX::Document<char>* doc_;

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testCreate() {
    //[hLg
    // <?xml version="1.0" encoding="UTF-8"?>
    // <TestSuite name="DocumentTest">
    // <TestCase name="testCreate"/>
    // <TestCase name="testString"/>
    // <!--This is test for MiX::Document-->
    // </TestSuite>
    doc_ = &(MiX::Document<char>::create("TestSuite"));
    CPPUNIT_ASSERT_EQUAL(doc_->getType(),MiX::Node_Document);
    MiX::Attribute<char>::create("version","1.0",*doc_);
    MiX::Attribute<char>::create("encoding","UTF-8",*doc_);
    MiX::Element<char>& el = doc_->getRoot();
    MiX::Attribute<char>::create("name","DocumentTest",el);
    MiX::Attribute<char>::create("name","testCreate",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Attribute<char>::create("name","testString",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Comment<char>::create("This is test for MiX::Document",el);
  }
  void testString() {
    std::string data("<!--This is test for MiX::Document-->");
    MiX::NodeList<char>::iterator it = doc_->getRoot().getChildren().end();
    --it;
    CPPUNIT_ASSERT((*it)->toString()==data);
  }
  void testClone() {
    const char data[] = {
      "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
      "<TestSuite name=\"DocumentTest\">"
      "<TestCase name=\"testCreate\"/>"
      "<TestCase name=\"testString\"/>"
      "<!--This is test for MiX::Document-->"
      "<!--This is test for MiX::Document-->"
      "</TestSuite>"
    };
    MiX::NodeList<char>::iterator it = doc_->getRoot().getChildren().end();
    MiX::Comment<char>& com = dynamic_cast<MiX::Comment<char>&>(**(--it));
    com.clone(doc_->getRoot());
    CPPUNIT_ASSERT(doc_->toString()==data);
  }
  void testOtherOps() { }
  void testDestroy() {
    doc_->destroy();
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

MiX::Document<char>* CommentTest::doc_ = 0;

CPPUNIT_TEST_SUITE_REGISTRATION(CommentTest);
