//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>
#include "../src/MiX/Document.h"
#include "../src/MiX/Element.h"
#include "../src/MiX/Attribute.h"
#include "../src/MiX/Text.h"

//CUPPA:namespace=+
//CUPPA:namespace=-

class NodeListTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(NodeListTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testTemplateIterator);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...
  MiX::Document<char>* doc_;
public:

  virtual void setUp() {
    //[hLg
    // <?xml version="1.0" encoding="UTF-8"?>
    // <TestSuite name="DocumentTest">
    //   This is test for MiX::Document.
    //   <TestCase name="testCreate"/>
    //   <TestCase name="testString"/>
    //   <Description>This is test for MiX::Document</Description>
    //   <!-- -->
    //   <TestTarget type="MiX::Document" name="doc_"/>
    // </TestSuite>
    doc_ = &(MiX::Document<char>::create("TestSuite"));
    CPPUNIT_ASSERT_EQUAL(doc_->getType(),MiX::Node_Document);
    MiX::Attribute<char>::create("version","1.0",*doc_);
    MiX::Attribute<char>::create("encoding","UTF-8",*doc_);
    MiX::Element<char>& el = doc_->getRoot();
    MiX::Attribute<char>::create("name","DocumentTest",el);
    MiX::Text<char>::create("This is test for MiX::Document.",el);
    MiX::Attribute<char>::create("name","testCreate",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Attribute<char>::create("name","testString",
				 MiX::Element<char>::create("TestCase",el));
    MiX::Comment<char>::create(" ",el);
    MiX::Element<char>& tar = MiX::Element<char>::create("TestTarget",el);
    MiX::Attribute<char>::create("type","MiX::Document",tar);
    MiX::Attribute<char>::create("name","doc_",tar);
  }
  virtual void tearDown() {
    doc_->destroy();
  }

//CUPPA:decl=+
  void testTemplateIterator() {
    int n;
    MiX::NodeList<char> lst = doc_->getRoot().getChildren();
    {
      MiX::NodeList<char>::Iterator<MiX::Element<char> > it = lst.Begin<MiX::Element<char> >();
      MiX::NodeList<char>::Iterator<MiX::Element<char> > last = lst.End<MiX::Element<char> >();
      for( ; it!=last ; ++it){
	CPPUNIT_ASSERT(it->getType()==MiX::Node_Element);
      }
    }
    {
      MiX::NodeList<char>::Iterator<MiX::Text<char> > it = lst.Begin<MiX::Text<char> >();
      MiX::NodeList<char>::Iterator<MiX::Text<char> > last = lst.End<MiX::Text<char> >();
      for(n=0 ; it!=last ; ++it, ++n){
	CPPUNIT_ASSERT(it->getType()==MiX::Node_Text);
	CPPUNIT_ASSERT(it->getValue()=="This is test for MiX::Document.");
	CPPUNIT_ASSERT(n==0);
      }
    }
    {
      MiX::NodeList<char>::Iterator<MiX::Comment<char> > it = lst.Begin<MiX::Comment<char> >();
      MiX::NodeList<char>::Iterator<MiX::Comment<char> > last = lst.End<MiX::Comment<char> >();
      for(n=0 ; it!=last ; ++it, ++n){
	CPPUNIT_ASSERT(it->getType()==MiX::Node_Comment);
	CPPUNIT_ASSERT(it->getValue()==" ");
	CPPUNIT_ASSERT(n==0);
      }
    }
    {
      MiX::NodeList<char>::Iterator<MiX::Attribute<char> > it = lst.Begin<MiX::Attribute<char> >();
      MiX::NodeList<char>::Iterator<MiX::Attribute<char> > last = lst.End<MiX::Attribute<char> >();
      for(n=0 ; it!=last ; ++it, ++n){
	CPPUNIT_ASSERT(it->getType()==MiX::Node_Attribute);
	CPPUNIT_ASSERT(it->getName()=="name");
	CPPUNIT_ASSERT(it->getValue()=="DocumentTest");
	CPPUNIT_ASSERT(n==0);
      }
    }
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(NodeListTest);
