//CUPPA:include=+
#include "../src/MiX/XMLToken.h"
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

class XMLTokenTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(XMLTokenTest);
//CUPPA:suite=+
  CPPUNIT_TEST(testInit);
  CPPUNIT_TEST(testData);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() { /* initialize */ }
  virtual void tearDown() { /* terminate */ }

//CUPPA:decl=+
  void testInit() {
    MiX::XMLToken<char> tok;
    CPPUNIT_ASSERT_EQUAL(-1,(int)tok.getIndex());
    CPPUNIT_ASSERT(MiX::Token_null==tok.getType());
  }
  void testData() {
    char data[] = "abcdefghijk";
    MiX::XMLToken<char> tok(data+3,data+5,MiX::Token_amp,3);
    CPPUNIT_ASSERT_EQUAL(3,(int)tok.getIndex());
    CPPUNIT_ASSERT(MiX::Token_amp==tok.getType());
    CPPUNIT_ASSERT(tok.getData()=="de");
  }
//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(XMLTokenTest);
