// -*- mode: c++ -*-

#ifndef MiX_ELEMENT_H_
#define MiX_ELEMENT_H_

#include "classes.h"
#include "misc.h"
#include "NodeContainer.h"
#include "extern/noncopyable.hpp"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class Element 
    : boost::noncopyable,
      public NodeContainer<charT,char_traits,xml_traits>, 
      public NamedNode<charT,char_traits,xml_traits>{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef Element<charT,char_traits,xml_traits> this_type;
    typedef typename nodelist_type::iterator nodelist_iter; 
  private:
    const static typename nodelist_type::iterator dmy_it;
  protected:
    /**
     * RXgN^
     *
     *  Element̃RXgN^͒ڌĂׂ܂<br>
     *  Element<...>::createŐĂ
     *
     *  Element̖OURL͎qAgr[g܂Ńp[WO
     *  ݒ肵Ȃ΂ȂȂ̂ŁARXgN^͖OԂɐGȂB
     */
    Element(const string_type& name)
      : NodeContainer<charT,char_traits,xml_traits>(),
	NamedNode<charT,char_traits,xml_traits>(name){ };
  public:
    /// fXgN^
    virtual ~Element()throw(){ };
    /// ̃m[h̃^Cv𓾂܂
    virtual NodeType getType()const{ return Node_Element; };
    /**
     * ÓIɃNXNodeType𓾂܂
     *
     * Node_ElementԂ܂
     */
    static NodeType type(){ return Node_Element; };
    /**
     * qElementɃANZX܂
     *
     * szNameŗ^ꂽOiIndexԖڂElementւ̎QƂԂ܂
     * ȂꍇDomException<...>𓊂܂
     */
    this_type& operator() (const string_type& name,int index=0){
      return getElement(name,index);
    };
    this_type& operator() (const string_type& name,const string_type& ns,int index=0){
      return getElement(name,ns,index);
    };
    /**
     * qAttributeɃANZX܂
     *
     * szNameŗ^ꂽOAttributeւ̎QƂԂ܂
     * ȂꍇDomException<...>𓊂܂
     */
    attribute_type& operator[] (const string_type& name){
      return getAttribute(name);
    };
    attribute_type& operator[] (std::pair<string_type,string_type> p){
      return getAttribute(p.first,p.second);
    };
    /**
     * Element̕\𓾂܂
     *
     *  bIndent^̎ACfgǉ܂
     */
    virtual string_type toString(bool is_indent=false,const string_type& idt=xml_traits::indent(),int indent_off=0)const;

    ///qText̒lAĕԂ܂
    string_type getText()const;

    ///qTextSďAs̒lqText𐶐܂B
    void setText(const XMLString<charT,char_traits,xml_traits>& s);

    string_type getFullName() const;
    /**
     * Element𕡐܂
     *
     *  \param parent ̐em[h
     *  \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    node_type& clone(nodecontainer_type& parent,const nodelist_iter& it = dmy_it) const;
    /**
     * Element𐶐܂
     *
     * \param name Element̖O
     * \param parent Element̐em[h
     * \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    static this_type& create(const string_type& name,this_type& parent,const typename nodelist_type::iterator& it = dmy_it)
      { return this_type::create(name,string_type(),parent,it); }
    /**
     * Element𐶐܂
     *
     * \param name Element̖O
     * \param ns Element̖OԂURL
     * \param parent Element̐em[h
     * \param it }ꏊ(parent.getChilds()̗vfCe[^łȂĂ͂Ȃ܂)
     */
    static this_type& create(const string_type& name,const string_type& ns,this_type& parent,const typename nodelist_type::iterator& it = dmy_it);

    friend class DOM_Parser<charT,char_traits,xml_traits>;
    friend class Document<charT,char_traits,xml_traits>;
  };
}

#ifndef MiX_ELEMENT_CPP_
#include "Element.cpp"
#endif

#endif
