// -*- mode: c++ -*-

#ifndef MIX_NODE_H_
#define MIX_NODE_H_

#include "classes.h"
#include "misc.h"
#include "DefaultXMLTraits.h"

namespace MiX{

  template <class charT,class char_traits,class xml_traits>
  class Node{
  public:
    MiX_Template_Typedef(charT,char_traits,xml_traits);
    typedef typename nodelist_type::iterator nodelist_iter; 
    typedef NamedNode<charT,char_traits,xml_traits> this_type;
  private:
    NodeContainer<charT,char_traits,xml_traits>* parent_;
  protected:
    /**
     * Rs[RXgN^
     *
     * NCAg͂ĂяoȂB܂Rs[łȂB
     */
    Node(const this_type& src){ };
    ///RXgN^
    Node(){ parent_ = 0; };
    ///em[hݒ
    void setParent(nodecontainer_type& parent){ parent_ = &parent; };
  public:
    /// fXgN^
    virtual ~Node()throw();
    /// j
    virtual void destroy()throw() { delete this; } ;
    /// em[hւ̎QƂ𓾂܂(const)
    const nodecontainer_type& getParent() const;
    /// em[hւ̎QƂ𓾂܂
    nodecontainer_type& getParent();
    /// ̃m[h̃^Cv𓾂܂
    virtual NodeType getType() const = 0;
    /**
     *  Node̕\𓾂܂
     * 
     * \param indent ̈true̎A`𓾂܂B
     * \param idt ̈w肳ꂽꍇACfg̋󔒂ƂĎw肳ꂽ
     * gp܂B
     * w肳Ȃꍇxml_traitsŎw肳ꂽlgp܂B
     * \param indent_off Ŏgp܂B
     */
    virtual string_type toString(bool indent=false,const string_type& idt=xml_traits::indent() ,int indent_off=0)const = 0;
    /// ̃m[h𕡐܂
    virtual node_type& clone(nodecontainer_type& parent,const nodelist_iter& it) const=0;
    friend class DOM_Parser<charT,char_traits,xml_traits>;
    friend class NodeContainer<charT,char_traits,xml_traits>;
  };
}

#ifndef MIX_NODE_CPP_
#include "Node.cpp"
#endif

#endif
