#define MIX_DOMPARSER_CPP_

#include "DOM_Parser.h"

#include "Attribute.h"
#include "Element.h"

namespace MiX{
  template <class Char,class Traits,class XMLTraits>
  void DOM_Parser<Char,Traits,XMLTraits>::onXMLDeclaration(AttrMap<Char,Traits,XMLTraits> attr){
    attrmap_type::iterator it = attr.begin();
    attrmap_type::iterator last = attr.end();
    for( ;it!=last;it++){
      attribute_type* attr= new attribute_type(it->first,it->second);
      current_->addChild(attr);
    }
  }
  
  template <class Char,class Traits,class XMLTraits>
  void DOM_Parser<Char,Traits,XMLTraits>::onStart(XMLString<Char,Traits,XMLTraits> name,AttrMap<Char,Traits,XMLTraits> attr){
    element_type* el = new element_type(name);
    current_->addChild(el);
    current_ = el;

    attrmap_type::iterator it = attr.begin();
    for( ;it!=attr.end();it++){
      attribute_type* att=new attribute_type(it->first,it->second);
      current_->addChild(att);
    }
  }
  
  template <class Char,class Traits,class XMLTraits>
  void DOM_Parser<Char,Traits,XMLTraits>::onEnd(XMLString<Char,Traits,XMLTraits> name){
    current_ = &(current_->getParent());
  }
  
  template <class Char,class Traits,class XMLTraits>
  void DOM_Parser<Char,Traits,XMLTraits>::onText(XMLString<Char,Traits,XMLTraits> text){
    text_type* t = new text_type(text);
    current_->addChild(t);
  }
  
  template <class Char,class Traits,class XMLTraits>
  void DOM_Parser<Char,Traits,XMLTraits>::onComment(XMLString<Char,Traits,XMLTraits> text){
    comment_type* com = new comment_type(text);
    current_->addChild(com);
  }

  template <class Char,class Traits,class XMLTraits>
  Document<Char,Traits,XMLTraits>& DOM_Parser<Char,Traits,XMLTraits>::parse(const Char* text){
    parser_.setEventHandler(this);
    document_type* doc = new document_type();
    current_ = doc;
    parser_.parse(text);
    return *doc;
  };
  
}
