// -*- mode: C++ -*-
#ifndef MIX_FUNCTIONS_H_
#define MIX_FUNCTIONS_H_

#include "misc.h"
#include "extern.h"

#include <functional>

/** \file Functions
 * ץߥ󥰻ʴؿ֥ȤƤޤ
 */

namespace MiX{
  /**
   * NodeType򸡾ڤץǥ
   *
   * 󥹥ȥ饯Υѥ᡼ȤͿ줿NodeTypeȡ
   * ؿΥѥ᡼ȤͿ줿NodeΥפʤп֤ޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class NodeTypeChecker
    : public MiX_STD::unary_function<const Node<Char,Traits,XMLTraits>*,bool>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
  private:
    NodeType type_;
  public:
    /// 󥹥ȥ饯
    NodeTypeChecker(NodeType t) : type_(t){ };
    /// nodeΥפȹۻΥѥ᡼tп
    result_type operator()(argument_type node)const{
      return (node->getType()==type_);
    };
  };

  /**
   * Ρɤ̾򸡾ڤץǥ
   *
   * 󥹥ȥ饯Υѥ᡼ȤͿ줿̾
   * ؿΥѥ᡼ȤͿ줿Node̾ʤп֤ޤ
   * Ϳ줿NodeNamedNodeǤϤʤäϵ֤ޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class NodeNameChecker : public MiX_STD::unary_function<const Node<Char,Traits,XMLTraits>*,bool>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
  private:
    string_type name_;
  public:
    ///󥹥ȥ饯
    NodeNameChecker(const string_type& name) : name_(name){ };
    ///node̾ۻͿ줿ѥ᡼nameп
    result_type operator()(argument_type node)const;
  };

  /**
   * ΡɤΥפ̾򸡾ڤץǥ
   *
   * NodeTypeCheckerNodeNameCheckerץǥǤ
   * ꤷפ̾ĥΡɤ򸡺ʤɤ˻Ѥޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class NamedNodeFinder
    : public boost::compose_f_gx_hx_t<MiX_STD::logical_and<bool>,NodeTypeChecker<Char,Traits,XMLTraits>,NodeNameChecker<Char,Traits,XMLTraits> >{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
  public:
    /**
     * 󥹥ȥ饯
     *
     * <dl><dt>type</dt><dd></dd>
     * <dt>name</dt><dd>̾</dd></dl>
     */
    NamedNodeFinder(NodeType type,const string_type& name)
      : boost::compose_f_gx_hx_t<MiX_STD::logical_and<bool>,NodeTypeChecker<Char,Traits,XMLTraits>,NodeNameChecker<Char,Traits,XMLTraits> >(MiX_STD::logical_and<bool>(),NodeTypeChecker<Char,Traits,XMLTraits>(type),NodeNameChecker<Char,Traits,XMLTraits>(name)){
    }
  };

}

#ifndef MIX_FUNCTIONS_CPP_
#include "Functions.cpp"
#endif

#endif
