// -*- mode: C++ -*-
#ifndef SOUPUTILS_STLXX_H_
#define SOUPUTILS_STLXX_H_
/*
 * STLxx By YotaroKubo
 * 
 * [[]]
 *   STLФ롢ۤΤ鷺ʳĥ
 *
 * [[С]]
 *  Ver0.1.0 
 *      for_each_if
 *  Ver0.1.1
 *      unary_null_function,binary_null_function
 *  Ver0.1.2
 *      pipe_function
 *      composit_function,composite_function2
 *         (boostƱǽ饹ä)
 *  Ver0.1.3
 *      cond_t,cond
 *      
 */

#include <functional>

namespace STLxx{
  /**
   * pred(*it)==trueǤФf(*it)¹Ԥ
   */
  template <class InputIter, class Function, class Pred>
  Function for_each_if(InputIter first, InputIter last, Function f, Pred pred) {
    for ( ; first != last; ++first)
      if(pred(*first)) f(*first);
    return f;
  }

  /**
   * ⤷ʤؿ֥
   */
  template <class Arg,class Result>
  class unary_null_function : std::unary_function<Arg,Result>{
  public:
    Result operator()(Arg a){return Result();};
  };

  /**
   * ⤷ʤؿ֥(binary)
   */
  template <class Arg1,class Arg2,class Result>
  class binary_null_function : std::binary_function<Arg1,Arg2,Result>{
  public:
    Result operator()(Arg1 a,Arg2 b){return Result();};
  };

  /**
   * ʤˤ⤷ʤؿ֥(򤽤Τޤ֤)
   */
  template <class T>
  class pipe_function : std::unary_function<T,T>{
  public:
    T operator()(T a){return a;};
  };

  /**
   * ץǥͤǼ¹Ԥؿʬؿ֥
   */
  template <class Pred,class ThenOp,class ElseOp>
  class cond_t
    : std::unary_function<typename ThenOp::argument_type,
			  typename ThenOp::result_type>{
    ThenOp then_;
    ElseOp else_;
    Pred pred_;
  public:
    cond_t(Pred pred,ThenOp thenop,ElseOp elseop)
      : then_(thenop),else_(elseop),pred_(pred){
    }
    typename ThenOp::result_type operator()(typename ThenOp::argument_type arg){
      if(pred_(arg)) return then_(arg);
      else return else_(arg);
    }
  };

  template <class Pred,class ThenOp,class ElseOp>
  cond_t<Pred,ThenOp,ElseOp> cond(Pred pred,ThenOp thenop,ElseOp elseop){
    return cond_t<Pred,ThenOp,ElseOp>(pred,thenop,elseop);
  }

  template <class Pred,class ThenOp>
  cond_t<Pred,ThenOp,unary_null_function<typename Pred::argument_type,typename ThenOp::result_type> > cond(Pred pred,ThenOp thenop){
    return cond_t<Pred,ThenOp,unary_null_function<typename Pred::argument_type,typename ThenOp::result_type> >(pred,thenop,unary_null_function<typename Pred::argument_type,typename ThenOp::result_type>());
  }
}

#endif
