// -*- mode: c++ -*-
#ifndef MIX_MISC_H_
#define MIX_MISC_H_

/** \file misc
 *   ֤Ƥ¤äΤϤƤޤ
 */

#include "classes.h"

namespace MiX{
  /**
   * ΡɤΥפɽ󷿤Ǥ
   *
   * 4ӥå = 0,[IsNodeContainer],[IsNamedNode],[IsValue]
   * 4ӥåȤϥˡ
   */
  enum NodeType{
    Node_Document = 0x40,
    Node_Element = 0x60,
    Node_Attribute = 0x30,
    Node_Text = 0x10,
    Node_Comment = 0x11,
    //ʲͤϼºݤΥΡɤˤϻѤʤ
    Node_NodeContainer = 0x40,
    Node_NamedNode = 0x20,
    Node_Value = 0x10,
  };
  
  ///顼פɽ󷿤Ǥ
  enum ErrorType{
    // for ParsingException
    UnexpectedToken = 0,
    XMLDeclarationNotFound,
    InternalError,
    UnexpectedEOD,
    InvalidHandler,
    InvalidDeclaration,
    MismatchElement,
    // for DomException
    NullException,
    NodeNotFound,
    NodeDuplication,
    InvalidNodeFound
  };

  /// toStringʤɤѤʸ˻tabɲäؿǤ
  template<class Char,class Traits,class XMLTraits>
  void insertIndent(int i,XMLString<Char,Traits,XMLTraits>& str,Char c){
    for(int j=0;j<i;j++) str+=c;
  }


#define MiX_Template_Typedef(C,T,X) typedef C char_type; \
    typedef T char_traits_type; \
    typedef X xml_traits_type; \
    typedef Node<C,T,X> node_type; \
    typedef Document<C,T,X> document_type; \
    typedef Element<C,T,X> element_type; \
    typedef Attribute<C,T,X> attribute_type; \
    typedef Text<C,T,X> text_type; \
    typedef Comment<C,T,X> comment_type; \
    typedef AttrMap<C,T,X> attrmap_type; \
    typedef XMLString<C,T,X> string_type; \
    typedef NodeList<C,T,X> nodelist_type; \
    typedef AttrMap<C,T,X> attrmap_type;
}

#endif
