#include <cppunit/extensions/TestSuiteBuilder.h>
#include <string>
#include <cstring> // strcmp
#include "DOM_Parser.test.h"

char DOM_ParserTest::teststring_[] = {
  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
  "<Root>"
  "  <Element1>Element1Text</Element1>"
  "  <Element2 attr=\"val\">Element2Text</Element2>"
  "  <Element3>"
  "    <Element4/>"
  "    <Element5>"
  "      Element5Text"
  "      <!--  Element5Comment  -->"
  "    </Element5>"
  "  </Element3>"
  "</Root>"
};

MBChar::MBCString DOM_ParserTest::teststring_mbc_ = MBChar::to_MBCS(
  "<?xml version=\"1.0\" encoding=\"EUC-JP\"?>"
  "<>"
  "  <ǰ>ǰŪʸ</ǰ>"
  "  < °=\"\">Ūʸ</>"
  "  <ǻ>"
  "    <ǻ/>"
  "    <Ǹ>"
  "      ǸŪʸ"
  "      <!--  ǸŪ  -->"
  "    </Ǹ>"
  "  </ǻ>"
  "</>"
);


void DOM_ParserTest::testParse(){
  DomParser parser;
  parser.setIgnoreSpace(true);
  Document& doc=parser.parse(teststring_);
  //ʲ
  CPPUNIT_ASSERT(doc.getRoot().getName()=="Root");
  CPPUNIT_ASSERT(doc["version"].getValue()=="1.0");
  CPPUNIT_ASSERT(doc["encoding"].getValue()=="UTF-8");
  CPPUNIT_ASSERT(doc.getChildren().size()==3);
  Element& root = doc.getRoot();
  CPPUNIT_ASSERT(root("Element1").getText()=="Element1Text");
  CPPUNIT_ASSERT(root("Element1").getChildren().size()==1);
  CPPUNIT_ASSERT(root("Element2")["attr"].getValue()=="val");
  CPPUNIT_ASSERT(root("Element2").getText()=="Element2Text");
  CPPUNIT_ASSERT(root("Element2").getChildren().size()==2);
  CPPUNIT_ASSERT(root("Element3").getChildren().size()==2);
  CPPUNIT_ASSERT(root("Element3")("Element4").getText()=="");
  CPPUNIT_ASSERT(root("Element3")("Element4").getChildren().size()==0);
  CPPUNIT_ASSERT(root("Element3")("Element5").getText()=="Element5Text");
  CPPUNIT_ASSERT(root("Element3")("Element5").getChildren().size()==2);
}

void DOM_ParserTest::testParseMBC(){
  DomParserMBC parser_mbc;
  parser_mbc.setIgnoreSpace(true);
  DocumentMBC& doc=parser_mbc.parse(teststring_mbc_.c_str());
  //ʲڡ
  CPPUNIT_ASSERT(doc.getRoot().getName()==MBChar::to_MBCS(""));
  CPPUNIT_ASSERT(doc[MBChar::to_MBCS("version").c_str()].getValue()==MBChar::to_MBCS("1.0"));
  CPPUNIT_ASSERT(doc[MBChar::to_MBCS("encoding").c_str()].getValue()==MBChar::to_MBCS("EUC-JP"));
  CPPUNIT_ASSERT(doc.getChildren().size()==3);
  ElementMBC& root = doc.getRoot();
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǰ").c_str()).getText()==MBChar::to_MBCS("ǰŪʸ"));
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǰ").c_str()).getChildren().size()==1);
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("").c_str())[MBChar::to_MBCS("°").c_str()].getValue()==MBChar::to_MBCS(""));
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("").c_str()).getText()==MBChar::to_MBCS("Ūʸ"));
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("").c_str()).getChildren().size()==2);
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǻ").c_str()).getChildren().size()==2);
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǻ").c_str())(MBChar::to_MBCS("ǻ").c_str()).getText()==MBChar::to_MBCS(""));
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǻ").c_str())(MBChar::to_MBCS("ǻ").c_str()).getChildren().size()==0);
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǻ").c_str())(MBChar::to_MBCS("Ǹ").c_str()).getText()==MBChar::to_MBCS("ǸŪʸ"));
  CPPUNIT_ASSERT(root(MBChar::to_MBCS("ǻ").c_str())(MBChar::to_MBCS("Ǹ").c_str()).getChildren().size()==2);
}


CppUnit::TestSuite* DOM_ParserTest::suite(){
  CppUnit::TestSuiteBuilder<DOM_ParserTest> builder("DomParser");
  builder.addTestCaller("Parse(SingleByteCharString)",
			&DOM_ParserTest::testParse);
  builder.addTestCaller("Parse(MultiByteCharString)",
			&DOM_ParserTest::testParseMBC);
  return builder.takeSuite();
}

