// -*- mode: C++ -*-
#ifndef MIX_TEST_DOMPARSER_H_
#define MIX_TEST_DOMPARSER_H_

#include "MBC.h"

#include <DefaultXMLTraits.h>
#include <Document.h>
#include <Element.h>
#include <Attribute.h>
#include <Text.h>
#include <Comment.h>
#include <DOM_Parser.h>

#include <cppunit/TestCase.h>
#include <cppunit/TestSuite.h>

class DOM_ParserTest : public CppUnit::TestCase{
  typedef MiX::Document<char> Document;
  typedef MiX::Document<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> DocumentMBC;
  typedef MiX::Element<char> Element;
  typedef MiX::Element<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> ElementMBC;
  typedef MiX::Attribute<char> Attribute;
  typedef MiX::Attribute<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> AttributeMBC;
  typedef MiX::Text<char> Text;
  typedef MiX::Text<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> TextMBC;
  typedef MiX::Comment<char> Comment;
  typedef MiX::Comment<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> CommentMBC;
  typedef MiX::DOM_Parser<char> DomParser;
  typedef MiX::DOM_Parser<MBChar::MBChar,MBChar::MBCharTraits,MBChar::MBCXMLTraits> DomParserMBC;

  static char teststring_[];
  static MBChar::MBCString teststring_mbc_;

  void testParse();
  void testParseMBC();
public:
  static CppUnit::TestSuite* suite();
  
};

#endif
