#include "MBC.h"

#include <string>

//using namespace MBChar;

namespace MBChar{

MBChar::MBChar(){
  data_[0]='\0';
  data_[1]='\0';
}

MBChar::MBChar(char c){ 
  data_[0]=c;
  data_[1]='\0';
}

MBChar::MBChar(char c1,char c2){ 
  data_[0]=c1;
  data_[1]=c2;
}

MBChar::MBChar(const MBChar& src){
  data_[0]=src.data_[0];
  data_[1]=src.data_[1];
}
MBChar::operator unsigned long()const{
  return data_[0]<<8 | data_[1];
}
const char* MBChar::getData()const{
  return data_;
}
char* MBChar::getData(){
  return data_;
}
bool MBChar::isKanji()const{
  if(MBChar::isKanji1stByte(data_[0])) return true;
  else return false;
}
bool MBChar::operator==(const char* s)const{
  return (data_[0]==s[0]) && (data_[1]==s[1]);
}
bool MBChar::isKanji1stByte(char c){
  ////For Shift-JIS
  //unsigned char d = static_cast<unsigned char>(c);
  //if((0x81<=d && d<=0x9F)||(0xE0<=d && d<=0xEA)) return true;
  //return false;  
  //Foe EUC-JP?
  unsigned char d = static_cast<unsigned char>(c);
  if((0xA0<=d && d<=0xA8)||(0xB0<=d && d<=0xF4)) return true;
  return false;  
}

std::ostream& operator<<(std::ostream& os,const MBChar& c){
  if(c.isKanji())
    os << c.getData()[0] << c.getData()[1];
  else
    os << c.getData()[0];
  return os;
}

MBCharTraits::int_type MBCharTraits::to_int_type(const MBCharTraits::char_type& c){
  return int_type(c);
}
void MBCharTraits::assign(MBCharTraits::char_type& c1,
			  const MBCharTraits::char_type& c2){
  c1 = c2;
}
bool MBCharTraits::eq(const MBCharTraits::char_type& c1,
		      const MBCharTraits::char_type& c2){
  return to_int_type(c1)==to_int_type(c2);
}
bool MBCharTraits::lt(const MBCharTraits::char_type& c1,
		      const MBCharTraits::char_type& c2){
  return to_int_type(c1)<to_int_type(c2);
}
int MBCharTraits::compare(const MBCharTraits::char_type* s1,
			  const MBCharTraits::char_type* s2,
			  size_t n){
  for(size_t i=0;i<n;++i)
    if(!eq(s1[i],s2[i]))
      return lt(s1[i],s2[i]) ? -1 : 1;
  return 0;
}
size_t MBCharTraits::length(const char_type* s){
  const char_type* p = s;
  while(to_int_type(*p)!=0) ++p;
  return p-s;
}
const MBCharTraits::char_type* MBCharTraits::find(const MBCharTraits::char_type* s,size_t n,const MBCharTraits::char_type& a){
  for(const MBCharTraits::char_type* p=s;size_t(p-s)<n;++p)
    if (MBCharTraits::eq(*p,a)) return p;
  return 0;
}
MBCharTraits::char_type* MBCharTraits::move(MBCharTraits::char_type* s1,const MBCharTraits::char_type* s2,size_t n){
  for(size_t i=0;i<n;++i){
    MBCharTraits::assign(s1[i],s2[i]);
  }
  return s1;
}
MBCharTraits::char_type* MBCharTraits::copy(MBCharTraits::char_type* s1,const MBCharTraits::char_type* s2,size_t n){
  return move(s1,s2,n);
}
MBCharTraits::char_type* MBCharTraits::assign(MBCharTraits::char_type* s,size_t n,MBCharTraits::char_type a){
  for(MBCharTraits::char_type* p=s;p<s+n;++p)
    MBCharTraits::assign(*p,a);
  return s;
}
MBCharTraits::char_type MBCharTraits::to_char_type(const MBCharTraits::int_type& c){
  return char_type(c);
}
bool MBCharTraits::eq_int_type(const MBCharTraits::int_type& c1,
			       const MBCharTraits::int_type& c2 ){
  return c1==c2;
}
MBCharTraits::int_type MBCharTraits::eof(){
  return static_cast<int_type>(-1);
}
MBCharTraits::int_type MBCharTraits::not_eof(const MBCharTraits::int_type& c){
  return MBCharTraits::eq_int_type(c,MBCharTraits::eof())
    ? MBCharTraits::int_type(0) : c;
}

MBCXMLTraits::char_type MBCXMLTraits::null(){
  return MBCXMLTraits::char_type('\0');    
}
MBCXMLTraits::char_type MBCXMLTraits::crlf(){
  return MBCXMLTraits::char_type('\n');
}
MBCXMLTraits::char_type MBCXMLTraits::sp(){
  return MBCXMLTraits::char_type(' ');
}
MBCXMLTraits::char_type MBCXMLTraits::tab(){
  return MBCXMLTraits::char_type('\t');
}
MBCXMLTraits::char_type MBCXMLTraits::lt(){
  return MBCXMLTraits::char_type('<');
}
MBCXMLTraits::char_type MBCXMLTraits::gt(){
  return MBCXMLTraits::char_type('>');
}
MBCXMLTraits::char_type MBCXMLTraits::eq(){
  return MBCXMLTraits::char_type('=');
}
MBCXMLTraits::char_type MBCXMLTraits::slash(){
  return MBCXMLTraits::char_type('/');
}
MBCXMLTraits::char_type MBCXMLTraits::hyphen(){
  return MBCXMLTraits::char_type('-');
}
MBCXMLTraits::char_type MBCXMLTraits::colon(){
  return MBCXMLTraits::char_type(':');
}
MBCXMLTraits::char_type MBCXMLTraits::semicolon(){
  return MBCXMLTraits::char_type(';');
}
MBCXMLTraits::char_type MBCXMLTraits::exclamation(){
  return MBCXMLTraits::char_type('!');
}
MBCXMLTraits::char_type MBCXMLTraits::question(){
  return MBCXMLTraits::char_type('?');
}
MBCXMLTraits::char_type MBCXMLTraits::amp(){
  return MBCXMLTraits::char_type('&');
}
MBCXMLTraits::char_type MBCXMLTraits::dblquote(){
  return MBCXMLTraits::char_type('\"');
}
MBCXMLTraits::char_type MBCXMLTraits::quote(){
  return MBCXMLTraits::char_type('\'');
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::xml(){
  MBCXMLTraits::char_type xml[3]={
    MBCXMLTraits::char_type('x'),MBCXMLTraits::char_type('m'),
    MBCXMLTraits::char_type('l')
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(xml,3);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::cdata(){
  MBCXMLTraits::char_type cdata[5]={
    MBCXMLTraits::char_type('C'),MBCXMLTraits::char_type('D'),
    MBCXMLTraits::char_type('A'),MBCXMLTraits::char_type('T'),
    MBCXMLTraits::char_type('A')
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(cdata,5);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::str_lt(){
  MBCXMLTraits::char_type lt[2]={
    MBCXMLTraits::char_type('l'),MBCXMLTraits::char_type('t')
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(lt,2);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::str_gt(){
  MBCXMLTraits::char_type gt[2]={
    MBCXMLTraits::char_type('g'),MBCXMLTraits::char_type('t')
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(gt,2);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::str_amp(){
  MBCXMLTraits::char_type amp[3]={
    MBCXMLTraits::char_type('a'),MBCXMLTraits::char_type('m'),
    MBCXMLTraits::char_type('p')
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(amp,3);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::str_quot(){
  MBCXMLTraits::char_type quot[4]={
      MBCXMLTraits::char_type('q'),MBCXMLTraits::char_type('u'),
      MBCXMLTraits::char_type('o'),MBCXMLTraits::char_type('t'),
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(quot,4);
}
std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type> MBCXMLTraits::str_apos(){
  MBCXMLTraits::char_type apos[4]={
    MBCXMLTraits::char_type('a'),MBCXMLTraits::char_type('p'),
    MBCXMLTraits::char_type('o'),MBCXMLTraits::char_type('s'),
  };
  return std::basic_string<MBCXMLTraits::char_type,MBCXMLTraits::traits_type>(apos,4);
}
int MBCXMLTraits::ci_compare(const MBCXMLTraits::char_type* s1,
			     const MBCXMLTraits::char_type* s2,
			     size_t n){
  for(size_t i=0;i<n;++i){
    if(s1[i].isKanji()^s2[i].isKanji()){
      return MBCXMLTraits::traits_type::lt(s1[i],s2[i])? -1 : 1; 
      break;
    }
    if(s1[i].isKanji()){
      return MBCXMLTraits::traits_type::lt(s1[i],s2[i])? -1 : 1;
      break;
    }else{
      if(std::tolower(s1[i].getData()[0])==std::tolower(s2[i].getData()[0]))
	continue;
      else
	return std::tolower(s1[i].getData()[0])<std::tolower(s2[i].getData()[0]) ? -1 : 1;
      break;
    }
  }
  return 0;
}

std::string to_str(const MBChar* src){
  std::string ret;
  const MBChar* p = src;
  while(static_cast<unsigned long>(*p)!=0){
    if(p->isKanji()){
      ret+=p->getData()[0];ret+=p->getData()[1];
    }else{
      ret+=p->getData()[0];
    }
    ++p;
  }
  return ret;
}

void to_str(const MBChar* src,char* buf,size_t size){
  std::string s = to_str(src);
  char* last = std::copy(s.begin(),s.begin()+std::min(s.length(),size),buf);
  *last=0;
}

void to_MBCS(const char* src,MBChar* buf,size_t size){
  MBCString s = to_MBCS(src);
  MBChar* last = std::copy(s.begin(),s.begin()+std::min(s.length(),size),buf);
  *last=MBChar();
}

MBCString to_MBCS(const char* src){
  MBCString ret;
  const char* p = src;
  char c = 0;
  while(*p!=0){
    if(MBChar::isKanji1stByte(*p)){
      c = *p;
      ++p;
    }
    else c=0;
    
    if(c) ret+=MBChar(c,*p);
    else  ret+=MBChar(*p);
    ++p;
  }
  return ret;
}

std::ostream& operator <<(std::ostream& os,const MBCString& str){
  os << to_str(str.c_str());
  return os;
}

}
