#include <MiX/MiX.h>

#include <iostream>
#include <fstream>

using namespace std;
using namespace MiX;


class EventHandler : public SAX_EventHandler<char>{
  int m_iIndent;
  ostream& m_out;
public:
  EventHandler(ostream& out) : m_out(out){
    m_iIndent = 0;
  }
  virtual void onXMLDeclaration(AttrMap<char> attr){
    m_out << "<html>" << endl
	  << "<head><title>Result of xml2html</title></head>" 
	  << endl << "<body>" << endl;
  };
  virtual void onStart(XMLString<char> sName,AttrMap<char> attr){
    m_out << "<span style=\"margin-left:" << 40*m_iIndent 
	  << "px\">" << "<b>&lt;" << sName << "</b>";
    AttrMap<char>::iterator it = attr.begin();
    for( ;it!=attr.end();it++){
      m_out << " " << it->first 
	    << " = <span style=\"color: #000055;\">\'" 
	    << it->second << "\'</span>" << endl;
    }
    m_out << "<b>&gt;</b>" << flush;
    m_out << "</span><br>" << endl;;
    ++m_iIndent;
  };
  virtual void onEnd(XMLString<char> sName){
    m_iIndent--;
    m_out << "<span style=\"margin-left:" << 40*m_iIndent 
	  << "px\">" << "<b>&lt;/" << sName << "&gt;</b>" 
	  << "</span><br>";
    if(m_iIndent==0){
      m_out << "</body></html>" << endl;
    }
  };
  virtual void onText(XMLString<char> sText){
    m_out << "<span style=\"margin-left:" << 40*m_iIndent 
	  << "px\">" << sText << "</span><br>";
  };
  virtual void onComment(XMLString<char> sText){
    m_out << "<span style=\"margin-left:" << 40*m_iIndent 
	  << "px\">" << "<span style=\"color: #777777;\">" 
	  << "&lt;!-" << sText << "--&gt;" 
	  << "</span>" << "</span><br>";
  };
};

int main(int argc,char* argv[]){
  XMLString<char> str;
  char c;
  cin.read(&c,sizeof(char));
  while(!cin.eof()){
    str += c;
    cin.read(&c,sizeof(char));
  }
  try{
    SAX_Parser<char> parser;
    EventHandler handler(std::cout);
    parser.setIgnoreSpace(true);
    parser.setEventHandler(&handler);
    parser.parse(str.c_str());

    return 0;
  }catch(ParsingException& e){
    cerr << e.what() << endl;
    return -1;
  }
}
