// -*- mode: c++ -*-
#ifndef MIX_ATTRIBUTE_H_
#define MIX_ATTRIBUTE_H_

#include "classes.h"
#include "misc.h"
#include "XMLString.h"
#include "NamedNode.h"
#include "Value.h"

namespace MiX{
  /**
   * ElementDocument°ɽ饹Ǥ.
   *
   * ͤ̾ݻޤ
   */
  template <class Char,class Traits,class XMLTraits>
  class Attribute : public Value<Char,Traits,XMLTraits> ,
		    public NamedNode<Char,Traits,XMLTraits>{
  public:
    MiX_Template_Typedef(Char,Traits,XMLTraits);
    typedef Attribute<Char,Traits,XMLTraits> this_type;
    typedef NodeContainer<Char,Traits,XMLTraits> nodecontainer_type;
  protected:
    /**
     * 󥹥ȥ饯
     *
     * AttributeΥ󥹥ȥ饯ľܸƤ٤ޤ<br>
     * Attribute<...>::createƤ
     */
    Attribute(const string_type& name,const string_type& val)
      : Value<Char,Traits,XMLTraits>(val),
	NamedNode<Char,Traits,XMLTraits>(name){ };
    /**
     * ԡ󥹥ȥ饯
     *
     * AttributeϥԡǤޤ
     */
    Attribute(const this_type& src){ };
  public:
    ///ǥȥ饯
    virtual ~Attribute()throw() { };
    ///ΥΡɤΥפޤ
    virtual NodeType getType()const { return Node_Attribute; };
    /**
     * Ū˥饹NodeTypeޤ.
     *
     * Node_Attribute֤ޤ
     */
    static NodeType type(){ return Node_Attribute; };
    /**
     * Attributeʸɽޤ.
     *
     * ̵뤵ޤ
     */
    virtual string_type toString(bool dmy=false,int dmy2=0)const;

    /**
     * Attributeޤ.
     *
     * <dl>
     *  <dt>key</dt>
     *  <dd>Attribute̾</dd>
     *  <dt>val</dt>
     *  <dd>Attribute</dd>
     *  <dt>parent</dt>
     *  <dd>AttributeοƥΡ</dd>
     * </dl>
     */
    static this_type& create(const string_type& key,const string_type& val,nodecontainer_type& parent);
    
    friend class DOM_Parser<Char,Traits,XMLTraits>;
  };
}

#ifndef MIX_ATTRIBUTE_CPP_
#include "Attribute.cpp"
#endif//MIX_ATTRIBUTE_CPP_

#endif
