// -*- mode: c++ -*-
#ifndef MIX_DEFAULTXMLTRAITS_H_
#define MIX_DEFAULTXMLTRAITS_H_

#include <string>
#include "config.h"

namespace MiX{
  /**
   * XMLʸ˴ؤǥեȥݥꥷ(monostate)
   *
   * ̤ʸѤϤѤȼXMLTraits
   * κݥ󥿡եϤƱˤ뤳
   */
  template <class Char,class Traits>
  class DefaultXMLTraits{
  public:
    typedef MiX_STD::basic_string<Char,Traits> basic_string_type;
  private:
    static basic_string_type makeString(const char* szSrc);

  public:
    ///ʸν򤢤魯ʸ֤ޤ
    static Char null(){ return static_cast<Char>('\0'); }
    ///Ԥν򤢤魯ʸ֤ޤ
    static Char crlf(){ return static_cast<Char>('\n'); }
    ///ʸ֤ޤ
    static Char sp(){ return static_cast<Char>(' '); }
    ///֤֤ޤ
    static Char tab(){ return static_cast<Char>('\t'); }

    ///'<'ʸ֤ޤ
    static Char lt(){ return static_cast<Char>('<'); }
    ///'='ʸ֤ޤ
    static Char eq(){ return static_cast<Char>('='); }
    ///'>'ʸ֤ޤ
    static Char gt(){ return static_cast<Char>('>'); }

    ///'/'ʸ֤ޤ
    static Char slash(){ return static_cast<Char>('/'); }
    ///'-'ʸ֤ޤ
    static Char hyphen(){ return static_cast<Char>('-'); }
    ///':'ʸ֤ޤ
    static Char colon() { return static_cast<Char>(':'); }
    ///';'ʸ֤ޤ
    static Char semicolon(){ return static_cast<Char>(';'); }

    ///'!'ʸ֤ޤ
    static Char exclamation(){ return static_cast<Char>('!'); }
    ///'?'ʸ֤ޤ
    static Char question(){ return static_cast<Char>('?'); }
    ///'&'ʸ֤ޤ
    static Char amp(){ return static_cast<Char>('&'); }

    ///'\"'ʸ֤ޤ
    static Char dblquote() { return static_cast<Char>('\"'); }
    ///'\''ʸ֤ޤ
    static Char quote() { return static_cast<Char>('\''); }

    //ʸ
    //XMLʸǻȤʸ֤
    ///"xml"ʸ֤ޤ
    static basic_string_type xml(){ 
      return makeString("xml");
    }
    ///"CDATA"ʸ֤ޤ
    static basic_string_type cdata(){
      return makeString("CDATA");
    }
    ///"lt"ʸ֤ޤ
    static basic_string_type str_lt(){
      return makeString("lt");
    }
    ///"gt"ʸ֤ޤ
    static basic_string_type str_gt(){
      return makeString("gt");
    }
    ///"amp"ʸ֤ޤ
    static basic_string_type str_amp(){
      return makeString("amp");
    }
    ///"quot"ʸ֤ޤ
    static basic_string_type str_quot(){
      return makeString("quot");
    }
    ///"apos"ʸ֤ޤ
    static basic_string_type str_apos(){
      return makeString("apos");
    }

    ///ʸʸ̤ʤӤԤޤ
    /**
     * ʸʸ̤ʤӤԤޤ
     * s1s2nʸܤޤ١
     * s1>s2ΤȤϤ
     * s1==s2ΤȤ0
     * s1<s2ΤȤ֤ͤޤ
     */
    static int ci_compare(const Char* s1,const Char* s2,size_t n){
      for(size_t i=0;i<n;i++){
	int c1,c2;
	c1 = tolower(static_cast<int>(s1[i]));
	c2 = tolower(static_cast<int>(s2[i]));
	if(c1>c2) return 1;
	if(c1<c2) return -1;
      }
      return 0;
    }
    
  };
}

#ifndef MIX_DEFAULTXMLTRAITS_CPP_
#include "DefaultXMLTraits.cpp"
#endif

#endif
