#define MIX_DOCUMENT_CPP_

#include <iostream>
#include <sstream>

#include "config.h"
#include "Document.h"
#include "DOM_Exception.h"
#include "NodeList.h"

namespace MiX{

  template <class Char,class Traits,class XMLTraits>
  Element<Char,Traits,XMLTraits>& Document<Char,Traits,XMLTraits>::getRoot()const{
    nodelist_type::const_iterator it;
    NodeTypeChecker<Char,Traits,XMLTraits> pred(Node_Element);
    it = MiX_STD::find_if(getChildren().begin(),getChildren().end(),pred);
    if(it!=getChildren().end()) return dynamic_cast<element_type&>(**it);
    std::ostringstream sout;
    sout << "DOM_Exception" << MiX_STD::endl
	 << "RootNode not found" << MiX_STD::endl << MiX_STD::ends;
    throw DOM_Exception<Char,Traits,XMLTraits>(this,NodeNotFound,sout.str());
  }
  
  template <class Char,class Traits,class XMLTraits>
  XMLString<Char,Traits,XMLTraits> Document<Char,Traits,XMLTraits>::toString(bool is_indent,int indent_off)const{
    string_type s;
    if(is_indent) insertIndent(indent_off,s,XMLTraits::tab());
    s += XMLTraits::lt(); s += XMLTraits::question(); 
    s += XMLTraits::xml();
    //ҥȥӥ塼Ȥʸ
    nodelist_type::const_iterator it = getChildren().begin();
    nodelist_type::const_iterator last = getChildren().end();
    for( ;it!=last;++it){
      if((*it)->getType()==Node_Attribute){
	s += XMLTraits::sp();
	s += (*it)->toString();
      }
    }
    s += XMLTraits::question(); s += XMLTraits::gt();
    if(is_indent) s += XMLTraits::crlf();
    s += getRoot().toString(is_indent,indent_off);
    return s;
  };
  
  template <class Char,class Traits,class XMLTraits>
  Document<Char,Traits,XMLTraits>& Document<Char,Traits,XMLTraits>::create(const XMLString<Char,Traits,XMLTraits>& rootname){
    document_type* newdoc = new document_type();
    element_type* newel = new element_type(rootname);
    newel->setParent(*newdoc);
    newdoc->getChildren().push_back(newel);
    return *newdoc;
  }
}
